/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.client.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class AttributeTooltipHelper {
    private AttributeTooltipHelper() {
    }

    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getAttributesBySlot(ItemStack stack) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            Multimap multimap = stack.m_41638_(equipmentSlot);
            if (multimap.isEmpty()) continue;
            map.put(equipmentSlot, multimap);
        }
        return map;
    }

    public static boolean matchesAttributeComponent(Component component, Attribute attribute, @Nullable AttributeModifier attributeModifier) {
        MutableComponent mutableComponent;
        TranslatableContents translatableContents = null;
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents1;
            translatableContents = translatableContents1 = (TranslatableContents)componentContents;
        } else if (component instanceof MutableComponent && !(mutableComponent = (MutableComponent)component).m_7360_().isEmpty() && (componentContents = ((Component)mutableComponent.m_7360_().get(0)).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents translatableContents1;
            translatableContents = translatableContents1 = (TranslatableContents)componentContents;
        }
        if (translatableContents != null) {
            Component component1;
            Object object;
            double scaledAmount = 0.0;
            String translationKey = null;
            if (attributeModifier != null) {
                scaledAmount = AttributeTooltipHelper.getScaledAttributeAmount(attribute, attributeModifier);
                if (attributeModifier.m_22218_() > 0.0) {
                    translationKey = "attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_();
                } else if (attributeModifier.m_22218_() < 0.0) {
                    scaledAmount *= -1.0;
                    translationKey = "attribute.modifier.take." + attributeModifier.m_22217_().m_22235_();
                }
            }
            Object[] args = translatableContents.m_237523_();
            if ((attributeModifier == null || translationKey != null && translatableContents.m_237508_().equals(translationKey)) && args.length >= 2 && (attributeModifier == null || args[0].equals(ItemStack.f_41584_.format(scaledAmount))) && (object = args[1]) instanceof Component && (object = (component1 = (Component)object).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents translatableComponent1 = (TranslatableContents)object;
                return translatableComponent1.m_237508_().equals(attribute.m_22087_());
            }
        }
        return false;
    }

    private static double getScaledAttributeAmount(Attribute attribute, AttributeModifier attributeModifier) {
        double attributeAmount = attributeModifier.m_22218_();
        if (attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) {
            if (attribute.equals(Attributes.f_22278_)) {
                return attributeAmount * 10.0;
            }
            return attributeAmount;
        }
        return attributeAmount * 100.0;
    }

    public static int removeAllAttributes(List<Component> lines) {
        int endIndex;
        int startIndex = AttributeTooltipHelper.findAttributesStart(lines);
        if (startIndex >= 0 && startIndex < (endIndex = AttributeTooltipHelper.findAttributesEnd(lines))) {
            for (int i = 0; i < endIndex - startIndex + 1; ++i) {
                lines.remove(startIndex);
            }
            return startIndex;
        }
        return -1;
    }

    public static int findAttributesStart(List<Component> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            TranslatableContents contents;
            ComponentContents componentContents = lines.get(i).m_214077_();
            if (!(componentContents instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).m_237508_().startsWith("item.modifiers.")) continue;
            if (--i >= 0 && lines.get(i).m_214077_() == ComponentContents.f_237124_) {
                return i;
            }
            return ++i;
        }
        return -1;
    }

    public static int findAttributesEnd(List<Component> lines) {
        int index = -1;
        for (int i = 0; i < lines.size(); ++i) {
            Component component = lines.get(i);
            TranslatableContents translatableComponent = null;
            ComponentContents componentContents = component.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatableComponent1;
                translatableComponent = translatableComponent1 = (TranslatableContents)componentContents;
            } else {
                ComponentContents componentContents2;
                LiteralContents textComponent;
                componentContents = component.m_214077_();
                if (componentContents instanceof LiteralContents && (textComponent = (LiteralContents)componentContents).f_237368_().equals(" ") && !component.m_7360_().isEmpty() && (componentContents2 = ((Component)component.m_7360_().get(0)).m_214077_()) instanceof TranslatableContents) {
                    TranslatableContents translatableComponent1;
                    translatableComponent = translatableComponent1 = (TranslatableContents)componentContents2;
                }
            }
            if (translatableComponent == null || !translatableComponent.m_237508_().startsWith("attribute.modifier.")) continue;
            index = i;
        }
        return index;
    }

    public static double calculateAttributeValue(@Nullable Player player, Attribute attribute, Collection<AttributeModifier> modifiers) {
        double baseValue = player != null && player.m_21204_().m_22171_(attribute) ? player.m_21172_(attribute) : 0.0;
        Map<AttributeModifier.Operation, List<AttributeModifier>> modifiersByOperation = modifiers.stream().collect(Collectors.groupingBy(AttributeModifier::m_22217_));
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.ADDITION, List.of())) {
            baseValue += attributeModifier.m_22218_();
        }
        double multipliedValue = baseValue;
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.MULTIPLY_BASE, List.of())) {
            multipliedValue += baseValue * attributeModifier.m_22218_();
        }
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.MULTIPLY_TOTAL, List.of())) {
            multipliedValue *= 1.0 + attributeModifier.m_22218_();
        }
        return attribute.m_6740_(multipliedValue);
    }
}

