/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.mixin;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")}, cancellable=true)
    protected void blockedByShield(LivingEntity target, CallbackInfo callback) {
        double knockBackStrength;
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).shieldKnockback == ServerConfig.ShieldKnockback.NONE) {
            return;
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).shieldKnockback == ServerConfig.ShieldKnockback.VARIABLE) {
            int variableShieldKnockbackDelay = ((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).variableShieldKnockbackDelay;
            if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).removeShieldDelay) {
                variableShieldKnockbackDelay += 5;
            }
            knockBackStrength = (double)(target.m_21211_().m_41779_() - target.m_21212_()) / (double)variableShieldKnockbackDelay;
            knockBackStrength = 1.0 - Mth.m_14008_((double)knockBackStrength, (double)0.0, (double)1.0);
            knockBackStrength += 0.5;
        } else {
            knockBackStrength = 0.5;
        }
        this.m_147240_(knockBackStrength, target.m_20185_() - this.m_20185_(), target.m_20189_() - this.m_20189_());
        callback.cancel();
    }

    @Shadow
    public abstract void m_147240_(double var1, double var3, double var5);

    @Inject(method={"isDamageSourceBlocked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getSourcePosition()Lnet/minecraft/world/phys/Vec3;", shift=At.Shift.BEFORE)}, cancellable=true)
    public void isDamageSourceBlocked(DamageSource damageSource, CallbackInfoReturnable<Boolean> callback) {
        Vec3 sourcePosition = damageSource.m_7270_();
        if (sourcePosition != null && !damageSource.m_269533_(DamageTypeTags.f_268524_)) {
            Vec3 viewVector = this.m_20252_(1.0f);
            Vec3 vec3 = sourcePosition.m_82505_(this.m_20182_()).m_82541_();
            vec3 = new Vec3(vec3.f_82479_, 0.0, vec3.f_82481_);
            double protectionArc = -Math.cos(((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).shieldProtectionArc * Math.PI * 0.5 / 180.0);
            callback.setReturnValue((Object)(vec3.m_82526_(viewVector) < protectionArc ? 1 : 0));
        }
    }
}

