/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.mixin;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ProjectileUtil.class})
abstract class ProjectileUtilMixin {
    @Unique
    private static Entity combatnouveau$pickedEntity;

    ProjectileUtilMixin() {
    }

    @ModifyVariable(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at=@At(value="STORE"), ordinal=2)
    private static Entity getEntityHitResult(Entity entity) {
        combatnouveau$pickedEntity = entity;
        return combatnouveau$pickedEntity;
    }

    @ModifyVariable(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at=@At(value="STORE"), ordinal=1)
    private static AABB getEntityHitResult(AABB aabb) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).minHitboxSize) {
            return aabb;
        }
        double minSize = 0.9;
        Objects.requireNonNull(combatnouveau$pickedEntity, "picked entity is null");
        if (combatnouveau$pickedEntity instanceof LivingEntity && (aabb.m_82362_() < minSize || aabb.m_82376_() < minSize || aabb.m_82385_() < minSize)) {
            return aabb.m_82377_(Math.max(0.0, minSize - aabb.m_82362_()) / 2.0, Math.max(0.0, minSize - aabb.m_82376_()) / 2.0, Math.max(0.0, minSize - aabb.m_82385_()) / 2.0);
        }
        return aabb;
    }
}

