/*
 * Decompiled with CFR 0.152.
 */
package com.pouffydev.tcompat.data.modifier;

import com.pouffydev.tcompat.data.builder.TComBaseRecipeProvider;
import com.pouffydev.tcompat.material.TComMaterialIds;
import com.pouffydev.tcompat.modifier.TComModifierIds;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TComModifierRecipeProv
extends TComBaseRecipeProvider {
    public TComModifierRecipeProv(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    public String m_6055_() {
        return "Tinker's Compatability Modifier Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addModifierRecipes(consumer);
        this.addTextureRecipes(consumer);
    }

    private void addModifierRecipes(Consumer<FinishedRecipe> consumer) {
        String abilityFolder = "tools/modifiers/ability/";
        String abilitySalvage = "tools/modifiers/salvage/ability/";
        Consumer aetherConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aether")});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)TComModifierIds.aetherForged).setTools(TinkerTags.Items.HARVEST)).addInput(TComModifierRecipeProv.itemTag("aether:gems/zanite")).addInput(TComModifierRecipeProv.itemTag("aether:golden_oak_logs")).addInput(TComModifierRecipeProv.itemTag("aether:gems/zanite")).addInput((ItemLike)Items.f_42054_).addInput((ItemLike)Items.f_42054_).setMaxLevel(1)).checkTraitLevel()).setSlots(SlotType.ABILITY, 1)).saveSalvage(aetherConsumer, this.prefix((ResourceLocation)TComModifierIds.aetherForged, abilitySalvage))).save(aetherConsumer, this.prefix((ResourceLocation)TComModifierIds.aetherForged, abilityFolder));
    }

    private void addTextureRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/modifiers/slotless/";
        Consumer otbwgConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("biomeswevegone")});
        Consumer aetherConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aether")});
        Consumer deepAetherConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("deep_aether")});
        for (MaterialVariantId materialVariantId : TComMaterialIds.otbwgVariantWoods) {
            this.woodTexture(otbwgConsumer, materialVariantId, "biomeswevegone");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.aetherVariantWoods) {
            this.woodTexture(aetherConsumer, materialVariantId, "aether");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.deepAetherVariantWoods) {
            this.woodTexture(deepAetherConsumer, materialVariantId, "deep_aether");
        }
    }

    private void woodTexture(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String namespace) {
        String folder = "tools/modifiers/slotless/";
        this.woodTexture(consumer, material, TComModifierRecipeProv.itemTag("%s:%s_planks".formatted(namespace, material.getVariant())), folder);
    }

    private void woodTexture(Consumer<FinishedRecipe> consumer, MaterialVariantId material, TagKey<Item> planks, String folder) {
        ((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier((LazyModifier)TinkerModifiers.embellishment, (String)material.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_WOOD)).addInput(planks).addInput((ItemLike)TinkerTables.pattern).addInput(planks).save(consumer, this.wrap((LazyModifier)TinkerModifiers.embellishment, folder, "/wood/" + material.getLocation('_').m_135815_()));
    }

    public ResourceLocation wrap(LazyModifier modifier, String prefix, String suffix) {
        return this.wrap((ResourceLocation)modifier.getId(), prefix, suffix);
    }

    private static ResourceKey<Item> itemKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name));
    }

    private static TagKey<Item> itemTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name));
    }
}

