/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.common;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.client.utils.ClientData;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.tags.ModBiomeTags;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void adastra$tick(CallbackInfo ci) {
        Player p;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && ((p = (Player)entity).m_7500_() || p.m_5833_())) {
            return;
        }
        if (entity.f_19797_ % 20 == 0) {
            if (AdAstraEvents.OxygenTickEvent.fire(level2, entity)) {
                OxygenApi.API.entityTick(level2, entity);
            }
            if (AdAstraEvents.TemperatureTickEvent.fire(level2, entity)) {
                TemperatureApi.API.entityTick(level2, entity);
            }
        }
        if (entity.f_19797_ % 10 == 0 && this.m_9236_().m_204166_(this.m_20183_()).m_203656_(ModBiomeTags.HAS_ACID_RAIN) && !this.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_ACID_RAIN) && !this.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_IN_SPACE) && this.adastra$isInRain()) {
            if (this.m_20202_() != null && this.m_20202_().m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_ACID_RAIN)) {
                return;
            }
            if (AdAstraEvents.AcidRainTickEvent.fire(level2, entity)) {
                entity.m_6469_(ModDamageSources.create(this.m_9236_(), ModDamageSources.ACID_RAIN), 3.0f);
                this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra$travel(Vec3 travelVector, CallbackInfo ci) {
        float gravity = GravityApi.API.getGravity(this);
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return;
            }
            if (this.m_9236_().m_5776_()) {
                gravity = ((Float)Optionull.m_269278_((Object)ClientData.getLocalData(), PlanetData::gravity, (Object)Float.valueOf(9.807f))).floatValue();
            }
        }
        BlockPos movementAffectingPos = this.m_20099_();
        if (gravity <= 0.05f) {
            if (AdAstraEvents.ZeroGravityTickEvent.fire(this.m_9236_(), entity, travelVector, movementAffectingPos)) {
                GravityApi.API.entityTick(this.m_9236_(), entity, travelVector, movementAffectingPos);
                ci.cancel();
            }
        } else if (AdAstraEvents.GravityTickEvent.fire(this.m_9236_(), entity, travelVector, movementAffectingPos)) {
            if (this.m_20069_() || this.m_20077_() || entity.m_21255_() || entity.m_21023_(MobEffects.f_19591_)) {
                return;
            }
            float newGravity = 0.08f * gravity;
            Vec3 velocity = this.m_20184_();
            this.m_20334_(velocity.m_7096_(), velocity.m_7098_() + (double)0.08f - (double)newGravity, velocity.m_7094_());
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if ((source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268434_)) && SpaceSuitItem.hasFullNetheriteSet(entity)) {
            entity.m_7311_(0);
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private float adastra$causeFallDamage(float multiplier) {
        return multiplier * GravityApi.API.getGravity(this);
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$causeFallDamage(float fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        if (!(fallDistance <= 3.0f / GravityApi.API.getGravity(this))) {
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$stopRiding(CallbackInfo ci) {
        Lander lander;
        Player player;
        Entity entity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (entity = (player = (Player)livingEntityMixin).m_20202_()) instanceof Lander && (lander = (Lander)entity).m_20186_() > (double)(AdAstraConfig.atmosphereLeave - 10)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean adastra$isInRain() {
        BlockPos pos = this.m_20183_();
        return this.m_9236_().m_46758_(pos) || this.m_9236_().m_46758_(BlockPos.m_274561_((double)pos.m_123341_(), (double)this.m_20191_().f_82292_, (double)pos.m_123343_()));
    }
}

