/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.TexturesResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="ldlib.gui.editor.group.textures", group="resource")
public class TexturesResource
extends Resource<IGuiTexture> {
    public static final String RESOURCE_NAME = "ldlib.gui.editor.group.textures";

    public TexturesResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/textures"));
        this.addBuiltinResource("empty", IGuiTexture.EMPTY);
    }

    @Override
    public void buildDefault() {
        this.addBuiltinResource("border background", ResourceBorderTexture.BORDERED_BACKGROUND);
        this.addBuiltinResource("button", ResourceBorderTexture.BUTTON_COMMON);
        this.addBuiltinResource("slot", SlotWidget.ITEM_SLOT_TEXTURE.copy());
        this.addBuiltinResource("fluid slot", TankWidget.FLUID_SLOT_TEXTURE.copy());
        this.addBuiltinResource("tab", TabContainer.TABS_LEFT.getSubTexture(0.0f, 0.0f, 0.5f, 0.33333334f));
        this.addBuiltinResource("tab pressed", TabContainer.TABS_LEFT.getSubTexture(0.5f, 0.0f, 0.5f, 0.33333334f));
        for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper : AnnotationDetector.REGISTER_TEXTURES) {
            this.addBuiltinResource("ldlib.gui.editor.register.texture." + wrapper.annotation().name(), wrapper.creator().get());
        }
    }

    @Override
    public String name() {
        return RESOURCE_NAME;
    }

    @Override
    public ResourceContainer<IGuiTexture, ImageWidget> createContainer(ResourcePanel panel) {
        return new TexturesResourceContainer(this, panel);
    }

    @Override
    public Tag serialize(IGuiTexture value) {
        return IGuiTexture.serializeWrapper(value);
    }

    @Override
    public IGuiTexture deserialize(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            return IGuiTexture.deserializeWrapper(tag);
        }
        return null;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.getBuiltinResources().clear();
        this.addBuiltinResource("empty", IGuiTexture.EMPTY);
        for (String key : nbt.m_128431_()) {
            this.addBuiltinResource(key, this.deserialize(nbt.m_128423_(key)));
        }
        for (IGuiTexture texture : this.getBuiltinResources().values()) {
            texture.setUIResource(this);
        }
    }
}

