/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public interface IFluidStorage
extends IFluidTransfer {
    public static final IFluidStorage EMPTY = new IFluidStorage(){

        @Override
        @NotNull
        public FluidStack getFluid() {
            return FluidStack.empty();
        }

        @Override
        public void setFluid(FluidStack fluid) {
        }

        @Override
        public long getCapacity() {
            return 0L;
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return false;
        }

        @Override
        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return 0L;
        }

        @Override
        public boolean supportsFill(int tank) {
            return false;
        }

        @Override
        @NotNull
        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return FluidStack.empty();
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return new Object();
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
        }
    };

    @Nonnull
    public FluidStack getFluid();

    public void setFluid(FluidStack var1);

    public long getCapacity();

    public boolean isFluidValid(FluidStack var1);

    default public long getFluidAmount() {
        return this.getFluid().getAmount();
    }

    @Override
    default public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    default public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Override
    default public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.setFluid(fluidStack);
    }

    @Override
    default public long getTankCapacity(int tank) {
        return this.getCapacity();
    }

    @Override
    default public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }
}

