/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.FacadeBlockAndTintGetter;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfo
implements IPersistedSerializable,
IConfigurable {
    public static final BlockInfo EMPTY = new BlockInfo(Blocks.f_50016_);
    @Configurable
    private BlockState blockState;
    private boolean hasBlockEntity;
    @Configurable
    private CompoundTag tag;
    @Configurable
    private ItemStack itemStack;
    private Consumer<BlockEntity> postCreate;
    private BlockEntity lastEntity;

    public BlockInfo(Block block) {
        this(block.m_49966_());
    }

    public BlockInfo(BlockState blockState) {
        this(blockState, false);
    }

    public BlockInfo(BlockState blockState, boolean hasBlockEntity) {
        this(blockState, hasBlockEntity, null, null);
    }

    public BlockInfo(BlockState blockState, Consumer<BlockEntity> postCreate) {
        this(blockState, true, null, postCreate);
    }

    public BlockInfo(BlockState blockState, boolean hasBlockEntity, ItemStack itemStack, Consumer<BlockEntity> postCreate) {
        this.blockState = blockState;
        this.hasBlockEntity = hasBlockEntity;
        this.itemStack = itemStack;
        this.postCreate = postCreate;
    }

    public static BlockInfo fromBlockState(BlockState state) {
        try {
            BlockEntity blockEntity;
            if (state.m_60734_() instanceof EntityBlock && (blockEntity = ((EntityBlock)state.m_60734_()).m_142194_(BlockPos.f_121853_, state)) != null) {
                return new BlockInfo(state, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BlockInfo(state);
    }

    public static BlockInfo fromBlock(Block block) {
        return BlockInfo.fromBlockState(block.m_49966_());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean hasBlockEntity() {
        return this.hasBlockEntity;
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        Block block;
        if (this.hasBlockEntity && (block = this.blockState.m_60734_()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            if (this.lastEntity != null && this.lastEntity.m_58899_().equals((Object)pos)) {
                return this.lastEntity;
            }
            this.lastEntity = entityBlock.m_142194_(pos, this.blockState);
            if (this.tag != null && this.lastEntity != null) {
                CompoundTag compoundTag2 = this.lastEntity.m_187482_();
                CompoundTag compoundTag3 = compoundTag2.m_6426_();
                compoundTag2.m_128391_(this.tag);
                if (!compoundTag2.equals((Object)compoundTag3)) {
                    this.lastEntity.m_142466_(compoundTag2);
                }
            }
            if (this.postCreate != null) {
                this.postCreate.accept(this.lastEntity);
            }
            return this.lastEntity;
        }
        return null;
    }

    public BlockEntity getBlockEntity(Level level, BlockPos pos) {
        BlockEntity entity = this.getBlockEntity(pos);
        if (entity != null) {
            entity.m_142339_(level);
        }
        return entity;
    }

    public ItemStack getItemStackForm() {
        return this.itemStack == null ? new ItemStack((ItemLike)this.blockState.m_60734_()) : this.itemStack;
    }

    public ItemStack getItemStackForm(BlockAndTintGetter level, BlockPos pos) {
        if (this.itemStack != null) {
            return this.itemStack;
        }
        return this.blockState.m_60734_().m_7397_((BlockGetter)new FacadeBlockAndTintGetter(level, pos, this.blockState, null), pos, this.blockState);
    }

    public void apply(Level world, BlockPos pos) {
        world.m_46597_(pos, this.blockState);
        BlockEntity blockEntity = this.getBlockEntity(pos);
        if (blockEntity != null) {
            world.m_151523_(blockEntity);
        }
    }

    public void clearBlockEntityCache() {
        this.lastEntity = null;
    }

    public BlockInfo() {
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public void setHasBlockEntity(boolean hasBlockEntity) {
        this.hasBlockEntity = hasBlockEntity;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public void setPostCreate(Consumer<BlockEntity> postCreate) {
        this.postCreate = postCreate;
    }
}

