/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TinkersInnovationConfig {
    private final Pair<Common, ForgeConfigSpec> commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
    private final Pair<Client, ForgeConfigSpec> clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
    private final Pair<Server, ForgeConfigSpec> serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
    public final Common common;
    public final Client client;
    public final Server server;

    public TinkersInnovationConfig(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.commonPair.getRight());
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientPair.getRight());
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.serverPair.getRight());
        this.common = (Common)this.commonPair.getLeft();
        this.client = (Client)this.clientPair.getLeft();
        this.server = (Server)this.serverPair.getLeft();
    }

    public static class Common {
        public static ForgeConfigSpec.ConfigValue<Integer> OmnipotentMaxLevel;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Config");
            OmnipotentMaxLevel = builder.comment("The max level of omnipotent modifier").defineInRange("MaxLevel", 2, 1, Integer.MAX_VALUE);
        }
    }

    public static class Client {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Server {
        public Server(ForgeConfigSpec.Builder builder) {
        }
    }
}

