/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationEffects;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class CalibrationModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook,
TooltipModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.TOOLTIP);
    }

    private static float getBonus(LivingEntity living) {
        return (float)(TinkerEffect.getAmplifier((LivingEntity)living, (MobEffect)((MobEffect)TinkersInnovationEffects.calibrationEffect.get())) + 1) / 16.0f;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        TinkersInnovationUtils.updateEffect(shooter, (MobEffect)TinkersInnovationEffects.calibrationEffect.get(), 1, 16, 100);
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.ACCURACY) {
            baseValue *= 1.0f + CalibrationModifier.getBonus(living) * (float)modifier.getLevel();
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null && tooltipKey.equals((Object)TooltipKey.SHIFT)) {
            TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)this, (FloatToolStat)ToolStats.ACCURACY, (TagKey)TinkerTags.Items.RANGED, (float)CalibrationModifier.getBonus((LivingEntity)player), tooltip);
        }
    }
}

