/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.library.modifiers.base.EnchantmentEffectsBase;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class EnchantmentModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook,
ProjectileLaunchModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_LAUNCH);
    }

    public void afterMeleeHit(@NotNull IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        int level = modifier.getLevel();
        LivingEntity player = context.getAttacker();
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            if (target.m_6084_()) {
                for (MobEffect effect : EnchantmentEffectsBase.getBadEffectsByCopy()) {
                    if (!((double)RANDOM.nextFloat() < 0.1)) continue;
                    TinkersInnovationUtils.updateEffect(target, effect, 1, 2 * level, 40 * level);
                }
            }
            for (MobEffect effect : EnchantmentEffectsBase.getGoodEffectsByCopy()) {
                if (!((double)RANDOM.nextFloat() < 0.1)) continue;
                TinkersInnovationUtils.updateEffect(player, effect, 1, 2 * level, 40 * level);
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, @NotNull ModifierEntry modifier, @NotNull Projectile projectile, EntityHitResult hit, @Nullable LivingEntity player, @Nullable LivingEntity target) {
        int level = modifier.getLevel();
        if (target != null && target.m_6084_()) {
            for (MobEffect effect : EnchantmentEffectsBase.getBadEffectsByCopy()) {
                if (!((double)RANDOM.nextFloat() < 0.1)) continue;
                TinkersInnovationUtils.updateEffect(target, effect, 1, 2 * level, 40 * level);
            }
        }
        return false;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        int level = modifier.getLevel();
        for (MobEffect effect : EnchantmentEffectsBase.getGoodEffectsByCopy()) {
            if (!((double)RANDOM.nextFloat() < 0.1)) continue;
            TinkersInnovationUtils.updateEffect(shooter, effect, 1, 2 * level, 40 * level);
        }
    }
}

