/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class OverImitateModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook {
    private final ResourceLocation KEY_ATTACK_DAMAGE = new ResourceLocation("tinkersinnovation", "over_imitate_attack_damage");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP});
    }

    void modifyImitateDamage(ModDataNBT data, float factor) {
        data.putFloat(this.KEY_ATTACK_DAMAGE, data.getFloat(this.KEY_ATTACK_DAMAGE) * factor);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        AttributeInstance attribute_damage;
        LivingEntity target = context.getLivingTarget();
        ModDataNBT data = tool.getPersistentData();
        if (target != null && (attribute_damage = target.m_21051_(Attributes.f_22281_)) != null) {
            data.putFloat(this.KEY_ATTACK_DAMAGE, (float)attribute_damage.m_22135_() * 0.2f * (float)modifier.getLevel());
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null) {
            AttributeInstance attribute;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.m_36781_(arrow.m_36789_() + (double)persistentData.getFloat(this.KEY_ATTACK_DAMAGE));
            }
            if ((attribute = target.m_21051_(Attributes.f_22281_)) != null) {
                persistentData.putFloat(this.KEY_ATTACK_DAMAGE, (float)attribute.m_22135_() * 0.2f * (float)modifier.getLevel());
            }
        }
        return false;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        return damage + tool.getPersistentData().getFloat(this.KEY_ATTACK_DAMAGE);
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.over_imitate_damage", (Object[])new Object[]{Float.valueOf(tool.getPersistentData().getFloat(this.KEY_ATTACK_DAMAGE))}));
    }
}

