/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationDamageTypes;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ResonanceModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT);
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            int radius = modifier.getLevel() + modifiers.getEntry(TinkerModifiers.expanded.getId()).getLevel();
            List<LivingEntity> targets = TinkersInnovationUtils.getLivingEntitiesInRange((Entity)target, radius, true);
            if (attacker != null) {
                targets.remove(attacker);
            }
            for (LivingEntity living : targets) {
                living.m_6469_(TinkerDamageTypes.source((RegistryAccess)target.m_9236_().m_9598_(), TinkersInnovationDamageTypes.RESONANCE, (Entity)projectile, (Entity)attacker), (float)(arrow.m_36789_() * (double)modifier.getLevel()));
            }
        }
        return false;
    }

    public void afterMeleeHit(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null) {
            int radius = modifier.getLevel() + tool.getModifierLevel(TinkerModifiers.expanded.getId());
            List<LivingEntity> targets = TinkersInnovationUtils.getLivingEntitiesInRange((Entity)target, radius, true);
            targets.remove(attacker);
            for (LivingEntity living : targets) {
                living.m_6469_(TinkerDamageTypes.source((RegistryAccess)target.m_9236_().m_9598_(), TinkersInnovationDamageTypes.RESONANCE, (Entity)attacker), damageDealt * 0.2f * (float)modifier.getLevel());
            }
        }
    }
}

