/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class RipeningModifier
extends Modifier
implements MeleeHitModifierHook,
BlockInteractionModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.BLOCK_INTERACT);
    }

    public void afterMeleeHit(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && target.m_6162_() && RANDOM.nextFloat() < 0.1f * (float)modifier.getLevel() && target instanceof AgeableMob) {
            AgeableMob age = (AgeableMob)target;
            age.m_6863_(false);
        }
    }

    @NotNull
    public InteractionResult afterBlockUse(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(context.m_43719_());
        if (player != null) {
            if (RipeningModifier.applyBonemeal(context.m_43722_(), tool, modifier, level, blockpos, player)) {
                if (!level.f_46443_) {
                    level.m_46796_(1505, blockpos, 0);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            BlockState blockstate = level.m_8055_(blockpos);
            if (blockstate.m_60783_((BlockGetter)level, blockpos, context.m_43719_()) && RipeningModifier.growWaterPlant(context.m_43722_(), tool, modifier, level, blockpos1, context.m_43719_(), player)) {
                if (!level.f_46443_) {
                    level.m_46796_(1505, blockpos1, 0);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static boolean applyBonemeal(ItemStack item, @NotNull IToolStackView tool, @NotNull ModifierEntry modifier, Level world, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        if (tool.getCurrentDurability() - tool.getDamage() < 100) {
            return false;
        }
        BlockState blockstate = world.m_8055_(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)world, (BlockPos)pos, (BlockState)blockstate, (ItemStack)item);
        if (hook != 0) {
            return hook > 0;
        }
        Block block = blockstate.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).m_7370_((LevelReader)world, pos, blockstate, world.f_46443_)) {
            if (world instanceof ServerLevel) {
                if (bonemealableblock.m_214167_(world, world.f_46441_, pos, blockstate)) {
                    bonemealableblock.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    if (RANDOM.nextFloat() > 0.2f * (float)modifier.getLevel()) {
                        bonemealableblock.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                        bonemealableblock.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    }
                }
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)25, (LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    private static boolean growWaterPlant(ItemStack item, @NotNull IToolStackView tool, @NotNull ModifierEntry modifier, Level world, BlockPos pos, @Nullable Direction direction, Player player) {
        if (tool.getCurrentDurability() - tool.getDamage() < 100) {
            return false;
        }
        if (world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_6425_(pos).m_76186_() == 8) {
            if (!(world instanceof ServerLevel)) {
                return true;
            }
            RandomSource random = world.m_213780_();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = Blocks.f_50037_.m_49966_();
                for (int j = 0; j < i / 16; ++j) {
                    if (world.m_8055_(blockpos = blockpos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_60838_((BlockGetter)world, blockpos)) continue block0;
                }
                Holder holder = world.m_204166_(blockpos);
                if (holder.m_203656_(BiomeTags.f_215804_)) {
                    if (i == 0 && direction != null && direction.m_122434_().m_122479_()) {
                        blockstate = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13052_).flatMap(p_204098_ -> p_204098_.m_213653_(world.f_46441_)).map(p_204100_ -> ((Block)p_204100_.m_203334_()).m_49966_()).orElse(blockstate);
                        if (blockstate.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                            blockstate = (BlockState)blockstate.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction);
                        }
                    } else if (random.m_188503_(4) == 0) {
                        blockstate = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13050_).flatMap(p_204091_ -> p_204091_.m_213653_(world.f_46441_)).map(p_204095_ -> ((Block)p_204095_.m_203334_()).m_49966_()).orElse(blockstate);
                    }
                }
                if (blockstate.m_204338_(BlockTags.f_13052_, blo -> blo.m_61138_((Property)BaseCoralWallFanBlock.f_49192_))) {
                    for (int k = 0; !blockstate.m_60710_((LevelReader)world, blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
                    }
                }
                if (!blockstate.m_60710_((LevelReader)world, blockpos)) continue;
                BlockState blockstate1 = world.m_8055_(blockpos);
                if (blockstate1.m_60713_(Blocks.f_49990_) && world.m_6425_(blockpos).m_76186_() == 8) {
                    world.m_7731_(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.m_60713_(Blocks.f_50037_) || random.m_188503_(10) != 0) continue;
                ((BonemealableBlock)Blocks.f_50037_).m_214148_((ServerLevel)world, random, blockpos, blockstate1);
                if (!(RANDOM.nextFloat() > 0.2f * (float)modifier.getLevel())) continue;
                ((BonemealableBlock)Blocks.f_50037_).m_214148_((ServerLevel)world, random, blockpos, blockstate1);
                ((BonemealableBlock)Blocks.f_50037_).m_214148_((ServerLevel)world, random, blockpos, blockstate1);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)25, (LivingEntity)player);
            return true;
        }
        return false;
    }
}

