/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class SoulLoverModifier
extends NoLevelsModifier
implements MeleeHitModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook,
ProjectileHitModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkersinnovation", "soul_lover");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_DAMAGE, ModifierHooks.MELEE_HIT, ModifierHooks.TOOLTIP, ModifierHooks.PROJECTILE_HIT});
    }

    public void setSoulLevel(IToolStackView tool, int value) {
        tool.getPersistentData().putInt(this.KEY, Math.min(Math.max(value, 0), 5));
    }

    public int getSoulLevel(IToolStackView tool) {
        return tool.getPersistentData().contains(this.KEY, 3) ? tool.getPersistentData().getInt(this.KEY) : 0;
    }

    public void addSoulLevel(IToolStackView tool, int value) {
        this.setSoulLevel(tool, this.getSoulLevel(tool) + value);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity attacker = context.getAttacker();
        if (attacker.m_21223_() <= attacker.m_21233_() - damageDealt && this.getSoulLevel(tool) < 5) {
            attacker.m_5634_(damageDealt / 2.0f);
            this.addSoulLevel(tool, 1);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (!persistentData.contains(this.KEY, 3)) {
            persistentData.putInt(this.KEY, 0);
        }
        if (target != null && persistentData.getInt(this.KEY) == 5 && projectile instanceof AbstractArrow) {
            arrow = (AbstractArrow)projectile;
            arrow.m_36781_(arrow.m_36789_() * 1.5);
            persistentData.putInt(this.KEY, 0);
        }
        if (persistentData.getInt(this.KEY) < 5 && attacker != null && projectile instanceof AbstractArrow) {
            arrow = (AbstractArrow)projectile;
            float damageDealt = (float)arrow.m_36789_();
            if (attacker.m_21223_() <= attacker.m_21233_() - damageDealt) {
                attacker.m_5634_(damageDealt / 2.0f);
                persistentData.putInt(this.KEY, persistentData.getInt(this.KEY) + 1);
            }
        }
        return false;
    }

    public float getMeleeDamage(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && this.getSoulLevel(tool) == 5) {
            damage *= 1.5f;
            this.setSoulLevel(tool, 0);
        }
        return damage;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (tooltipKey.equals((Object)TooltipKey.SHIFT)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.soul_level", (Object[])new Object[]{this.getSoulLevel(tool)}));
        }
    }
}

