/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.shared.TinkerEffects;

public class TransmutationModifier
extends Modifier
implements InventoryTickModifierHook,
ProcessLootModifierHook,
ModifierRemovalHook {
    private final ResourceLocation TRAN_KEY = new ResourceLocation("tinkersinnovation", "transmutation");
    private final ResourceLocation EXP_KEY = new ResourceLocation("tinkersinnovation", "transmutation_explode");

    public int getPriority() {
        return 80;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE, ModifierHooks.PROCESS_LOOT);
    }

    public void setExperienceLevel(IToolStackView tool, int value) {
        tool.getPersistentData().putInt(this.TRAN_KEY, Math.max(value, 0));
    }

    public int getExperienceLevel(IToolStackView tool) {
        return tool.getPersistentData().contains(this.TRAN_KEY, 3) ? tool.getPersistentData().getInt(this.TRAN_KEY) : 0;
    }

    public void addExperienceLevel(IToolStackView tool, int value) {
        this.setExperienceLevel(tool, this.getExperienceLevel(tool) + value);
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (this.getExperienceLevel(tool) <= 10) {
            int count = 0;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack stack : generatedLoot) {
                count += stack.m_41613_();
                if (!stack.m_41720_().m_142095_()) continue;
                list.add(stack);
            }
            this.addExperienceLevel(tool, count * modifier.getLevel());
            for (int i = 0; i < modifier.getLevel(); ++i) {
                generatedLoot.addAll(list);
            }
        }
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT data = tool.getPersistentData();
        if (!tool.isBroken()) {
            data.putBoolean(this.EXP_KEY, true);
        }
        if (this.getExperienceLevel(tool) > 0 && holder instanceof Player) {
            Player player = (Player)holder;
            if (player.f_36078_ > 0) {
                int exp = Math.min(player.f_36078_, this.getExperienceLevel(tool));
                player.f_36078_ -= exp;
                this.addExperienceLevel(tool, -exp);
                ToolDamageUtil.damage((IToolStackView)tool, (int)modifier.getLevel(), (LivingEntity)player, (ItemStack)stack);
                if ((double)RANDOM.nextFloat() < 0.05) {
                    MobEffectInstance effect = new MobEffectInstance((MobEffect)TinkerEffects.selfDestructing.get(), 200 - 20 * (modifier.getLevel() - 1));
                    effect.setCurativeItems(List.of(new ItemStack((ItemLike)Items.f_42455_)));
                    holder.m_7292_(effect);
                }
            }
        }
        if (this.getExperienceLevel(tool) > 10) {
            holder.m_6469_(TinkerDamageTypes.source((RegistryAccess)holder.m_9236_().m_9598_(), (ResourceKey)TinkerDamageTypes.SELF_DESTRUCT), 2.1474836E9f);
            this.setExperienceLevel(tool, 10);
        }
        if (tool.isBroken() && data.getBoolean(this.EXP_KEY)) {
            holder.m_6469_(TinkerDamageTypes.source((RegistryAccess)holder.m_9236_().m_9598_(), (ResourceKey)TinkerDamageTypes.SELF_DESTRUCT), 2.1474836E9f);
            holder.m_9236_().m_254849_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 2.0f, Level.ExplosionInteraction.BLOCK);
            data.putBoolean(this.EXP_KEY, false);
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }
}

