/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.recipes;

import com.gjhi.tinkersinnovation.register.TinkersInnovationItems;
import com.gjhi.tinkersinnovation.register.TinkersInnovationModifiers;
import com.gjhi.tinkersinnovation.register.TinkersInnovationRecipes;
import com.gjhi.tinkersinnovation.register.TinkersInnovationSlots;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class TraitsRestructuringRecipe
implements ITinkerStationRecipe {
    private final ResourceLocation id;
    private final int reinforcement_count = 5;

    public TraitsRestructuringRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(ITinkerStationContainer inv, Level level) {
        ToolStack tool = inv.getTinkerable();
        ItemStack stack = inv.getTinkerableStack();
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MULTIPART_TOOL)) {
            for (int i = 0; i < inv.getInputCount(); ++i) {
                ItemStack input = inv.getInput(i);
                if (!(input.m_41720_() instanceof IToolPart)) continue;
                List parts = ToolPartsHook.parts((ToolDefinition)tool.getDefinition());
                if (parts.isEmpty()) {
                    return false;
                }
                return this.checkMeta(inv) && parts.stream().anyMatch(p -> p.m_5456_() == input.m_41720_());
            }
        }
        return false;
    }

    private boolean checkMeta(ITinkerStationContainer inv) {
        ItemStack name_tag = ItemStack.f_41583_;
        ItemStack polychrome_alloy_reinforcement = ItemStack.f_41583_;
        ItemStack expensive = ItemStack.f_41583_;
        ItemStack difficult = ItemStack.f_41583_;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_150930_(Items.f_42656_)) {
                name_tag = input;
                continue;
            }
            if (input.m_150930_((Item)TinkersInnovationItems.polychrome_alloy_reinforcement.get())) {
                polychrome_alloy_reinforcement = input;
                continue;
            }
            if (input.m_150930_(Items.f_42791_)) {
                expensive = input;
                continue;
            }
            if (!input.m_150930_(Items.f_42686_)) continue;
            difficult = input;
        }
        return !name_tag.m_41619_() && !polychrome_alloy_reinforcement.m_41619_() && polychrome_alloy_reinforcement.m_41613_() >= 5 && !expensive.m_41619_() && !difficult.m_41619_();
    }

    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        ItemStack name_tag = ItemStack.f_41583_;
        ItemStack part = ItemStack.f_41583_;
        IToolPart part1 = null;
        ModifierEntry trait = null;
        if (tool.getFreeSlots(TinkersInnovationSlots.OMNIPOTENT) == 0) {
            return RecipeResult.failure((Component)Component.m_237110_((String)TConstruct.makeTranslationKey((String)"recipe", (String)"modifier.not_enough_slot"), (Object[])new Object[]{TinkersInnovationSlots.OMNIPOTENT.getDisplayName()}));
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            Item var6;
            ItemStack input = inv.getInput(i);
            if (input.m_150930_(Items.f_42656_)) {
                name_tag = input;
            }
            if (!((var6 = input.m_41720_()) instanceof IToolPart)) continue;
            IToolPart part2 = (IToolPart)var6;
            part = input;
            part1 = part2;
        }
        if (part1 != null && name_tag != ItemStack.f_41583_) {
            for (ModifierEntry trait1 : MaterialRegistry.getInstance().getTraits(part1.getMaterial(part).getId(), part1.getStatType())) {
                if (!trait1.getId().toString().equals(name_tag.m_41786_().getString())) continue;
                trait = trait1;
                break;
            }
        }
        if (trait != null) {
            if (trait.matches(TinkersInnovationModifiers.omnipotent.getId())) {
                return RecipeResult.failure((Component)Component.m_237115_((String)"recipe.tconstruct.modifier.traits_restructuring.omnipotent"));
            }
            ToolStack newTool = tool.copy();
            newTool.addModifier(trait.getId(), trait.getLevel());
            newTool.getPersistentData().addSlots(TinkersInnovationSlots.OMNIPOTENT, -1);
            return ITinkerStationRecipe.success((ToolStack)newTool, (ITinkerableContainer)inv);
        }
        return RecipeResult.failure((Component)Component.m_237115_((String)"recipe.tconstruct.modifier.traits_restructuring.not_included"));
    }

    public void updateInputs(@NotNull LazyToolStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        for (int index = 0; index < inv.getInputCount(); ++index) {
            if (inv.getInput(index).m_41720_().equals(TinkersInnovationItems.polychrome_alloy_reinforcement.get())) {
                inv.shrinkInput(index, 5);
                continue;
            }
            inv.shrinkInput(index, 1);
        }
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkersInnovationRecipes.TRAITS_RESTRUCTURING_RECIPE.get();
    }
}

