/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.register;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TinkersInnovationUtils {
    protected static Random RANDOM = new Random();

    public static boolean isInArmorSlots(EquipmentSlot slot) {
        return slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR);
    }

    public static boolean isInHandSlots(EquipmentSlot slot) {
        return slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND);
    }

    public static boolean isInArmorSlots(LivingEntity entity, ItemStack item) {
        for (ItemStack i : entity.m_6168_()) {
            if (!i.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInHandSlots(LivingEntity entity, ItemStack item) {
        for (ItemStack i : entity.m_6167_()) {
            if (!i.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShieldInHandSlots(IToolStackView tool, EquipmentSlot slot) {
        return tool.hasTag(TinkerTags.Items.SHIELDS) && TinkersInnovationUtils.isInHandSlots(slot);
    }

    public static boolean isShieldInHandSlots(IToolStackView tool, LivingEntity entity, ItemStack item) {
        return tool.hasTag(TinkerTags.Items.SHIELDS) && TinkersInnovationUtils.isInHandSlots(entity, item);
    }

    public static boolean isInSlots(EquipmentSlot slot) {
        return TinkersInnovationUtils.isInHandSlots(slot) || TinkersInnovationUtils.isInArmorSlots(slot);
    }

    public static boolean isInSlots(LivingEntity entity, ItemStack item) {
        return TinkersInnovationUtils.isInHandSlots(entity, item) || TinkersInnovationUtils.isInArmorSlots(entity, item);
    }

    @Nullable
    public static EquipmentSlot inWhichSlot(LivingEntity entity, ItemStack item) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!entity.m_6844_(slot).equals(item)) continue;
            return slot;
        }
        return null;
    }

    @Nullable
    public static ToolStack getToolFromHand(LivingEntity entity) {
        ItemStack stack;
        ItemStack mainItem = entity.m_21205_();
        ItemStack offItem = entity.m_21206_();
        Object object = mainItem.m_41619_() ? (offItem.m_41619_() ? null : offItem) : (stack = mainItem);
        return stack != null ? (ToolStack.from((ItemStack)stack).getDefinition() != ToolDefinition.EMPTY ? ToolStack.from((ItemStack)stack) : null) : null;
    }

    public static void updateEffect(LivingEntity entity, MobEffect effect, int addLevel, int maxLevel, int time) {
        MobEffectInstance mobeffect = entity.m_21124_(effect);
        if (mobeffect != null) {
            entity.m_7292_(new MobEffectInstance(effect, time, Math.min(mobeffect.m_19564_() + addLevel, maxLevel - 1)));
        } else {
            entity.m_7292_(new MobEffectInstance(effect, time, Math.min(addLevel - 1, maxLevel - 1)));
        }
    }

    public static List<LivingEntity> getLivingEntitiesInRange(Entity center, double range, boolean includeCenter) {
        List list = center.m_9236_().m_6443_(LivingEntity.class, center.m_20191_().m_82400_(range), entity -> entity instanceof LivingEntity);
        if (!includeCenter && center instanceof LivingEntity) {
            list.remove(center);
        }
        return list;
    }

    public static List<Player> getPlayersInRange(Entity center, double range, boolean includeCenter) {
        List list = center.m_9236_().m_6443_(Player.class, center.m_20191_().m_82400_(range), entity -> entity instanceof Player);
        if (!includeCenter && center instanceof Player) {
            list.remove(center);
        }
        return list;
    }

    public static List<Monster> getMonstersInRange(Entity center, double range, boolean includeCenter) {
        List list = center.m_9236_().m_6443_(Monster.class, center.m_20191_().m_82400_(range), entity -> entity instanceof Monster);
        if (!includeCenter && center instanceof Monster) {
            list.remove(center);
        }
        return list;
    }

    @Nullable
    public static <T> T getRandomInList(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(RANDOM.nextInt(list.size()));
    }

    public static float manhattanDistance(float x1, float y1, float z1, float x2, float y2, float z2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2);
    }

    @SafeVarargs
    public static <T> List<T> without(List<T> origin, T ... members) {
        ArrayList<T> list = new ArrayList<T>(origin);
        for (T member : members) {
            list.remove(member);
        }
        return list;
    }

    public static boolean noMixinDirectDamage(IToolStackView tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        int damage;
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return false;
        }
        int durability = tool.getStats().getInt((IToolStat)ToolStats.DURABILITY);
        int current = durability - (damage = tool.getDamage());
        if ((amount = Math.min(amount, current)) > 0) {
            int newDamage = damage + amount;
            if (entity instanceof ServerPlayer) {
                if (stack == null) {
                    stack = entity.m_21205_();
                }
                CriteriaTriggers.f_10586_.m_43669_((ServerPlayer)entity, stack, newDamage);
            }
            tool.setDamage(newDamage);
            return newDamage >= durability;
        }
        return false;
    }

    public static boolean spawnLightningBolt(Level world, int x, int y, int z, MobSpawnType type, float damage) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            LightningBolt flash = (LightningBolt)EntityType.f_20465_.m_262496_(level, new BlockPos(x, y, z), type);
            if (flash != null) {
                flash.setDamage(damage);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean spawnLightningBolt(Entity entity, MobSpawnType type, float damage) {
        return TinkersInnovationUtils.spawnLightningBolt(entity.m_9236_(), entity.m_146903_(), entity.m_146904_(), entity.m_146907_(), type, damage);
    }

    public static boolean spawnLightningBolt(Level world, int x, int y, int z, MobSpawnType type) {
        return TinkersInnovationUtils.spawnLightningBolt(world, x, y, z, type, TinkersInnovationUtils.getLightningBoltDamage());
    }

    public static boolean spawnLightningBolt(Entity entity, MobSpawnType type) {
        return TinkersInnovationUtils.spawnLightningBolt(entity.m_9236_(), entity.m_146903_(), entity.m_146904_(), entity.m_146907_(), type, TinkersInnovationUtils.getLightningBoltDamage());
    }

    public static float getLightningBoltDamage() {
        return 5.0f;
    }
}

