/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import net.dawson.adorablehamsterpets.ModRegistries;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.command.ModCommands;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.event.AHPCommonEvents;
import net.dawson.adorablehamsterpets.item.ModItemGroups;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.world.ModSpawnPlacements;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdorableHamsterPets {
    public static final String MOD_ID = "adorablehamsterpets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adorablehamsterpets");
    public static AhpConfig CONFIG;

    public static void initRegistries() {
        CONFIG = Configs.AHP;
        ModEntities.register();
        ModSounds.register();
        ModBlocks.register();
        ModItems.register();
        ModItemGroups.register();
        ModScreenHandlers.register();
        ModCriteria.register();
    }

    public static void initCommonSetup() {
        if (System.getProperty("fabric-api.datagen") == null) {
            ModRegistries.registerCompostables();
            ModEntitySpawns.parseConfig();
            ModWorldGeneration.parseConfig();
            ModItemTags.parseConfig();
            ModPackets.register();
            ModWorldGeneration.registerBiomeModifications();
            AHPCommonEvents.init();
            PlayerEvent.PLAYER_JOIN.register(AdorableHamsterPets::onPlayerJoin);
            PlayerEvent.PLAYER_CLONE.register(AdorableHamsterPets::onPlayerClone);
            CommandRegistrationEvent.EVENT.register(ModCommands::register);
            LifecycleEvent.SETUP.register(AdorableHamsterPets::onSetup);
        }
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(ModEntities.HAMSTER, HamsterEntity::createHamsterAttributes);
    }

    private static void onSetup() {
        ModSpawnPlacements.register((EntityType)ModEntities.HAMSTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) || ModEntitySpawns.VALID_SPAWN_BLOCKS.contains(world.m_8055_(pos.m_7495_()).m_60734_()));
    }

    private static void onPlayerJoin(ServerPlayer player) {
        if (Configs.AHP.enableAutoGuidebookDelivery) {
            PlayerAdvancements advancementTracker = player.m_8960_();
            ResourceLocation flagAdvId = ResourceLocation.m_214293_((String)MOD_ID, (String)"technical/has_received_initial_guidebook");
            Advancement flagAdvancement = player.f_8924_.m_129889_().m_136041_(flagAdvId);
            if (flagAdvancement != null) {
                AdvancementProgress flagProgress = advancementTracker.m_135996_(flagAdvancement);
                if (!flagProgress.m_8193_()) {
                    ModCriteria.FIRST_JOIN_GUIDEBOOK_CHECK.trigger(player);
                    for (String criterion : flagAdvancement.m_138325_().keySet()) {
                        advancementTracker.m_135988_(flagAdvancement, criterion);
                    }
                }
            } else {
                LOGGER.warn("Could not find flag advancement: {}", (Object)flagAdvId);
            }
        }
        AdorableHamsterPets.replaceOldBooksInInventory((Container)player.m_150109_());
    }

    private static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wasDeath) {
        PlayerEntityAccessor oldPlayerAccessor = (PlayerEntityAccessor)oldPlayer;
        PlayerEntityAccessor newPlayerAccessor = (PlayerEntityAccessor)newPlayer;
        for (ShoulderLocation location : ShoulderLocation.values()) {
            CompoundTag shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
            if (shoulderNbt.m_128456_()) continue;
            if (wasDeath) {
                ServerLevel world = oldPlayer.m_284548_();
                HamsterEntity.spawnFromNbt(world, (Player)oldPlayer, shoulderNbt, false, null);
                LOGGER.debug("Player {} died. Spawning {} hamster at death location.", (Object)oldPlayer.m_7755_().getString(), (Object)location);
                continue;
            }
            newPlayerAccessor.setShoulderHamster(location, shoulderNbt);
            LOGGER.debug("Player {} was cloned. Transferring {} hamster to new entity.", (Object)newPlayer.m_7755_().getString(), (Object)location);
        }
    }

    public static void replaceOldBooksInInventory(Container inventory) {
        if (inventory == null) {
            return;
        }
        String PATCHOULI_BOOK_TAG = "patchouli:book";
        String TARGET_BOOK_ID = new ResourceLocation(MOD_ID, "hamster_tips_guide_book").toString();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            boolean hasPatchouliBookTag;
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            CompoundTag nbt = stack.m_41783_();
            boolean bl = hasPatchouliBookTag = nbt != null && nbt.m_128425_("patchouli:book", 8);
            if (hasPatchouliBookTag) continue;
            ItemStack newBookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get(), stack.m_41613_());
            newBookStack.m_41784_().m_128359_("patchouli:book", TARGET_BOOK_ID);
            inventory.m_6836_(i, newBookStack);
            LOGGER.info("Upgraded an old Hamster Tips Guide Book to the new Patchouli version.");
        }
    }
}

