/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public class HamsterSleepGoal
extends Goal {
    private static final int CHECK_INTERVAL = 20;
    private final HamsterEntity hamster;
    private int checkTimer = 0;

    public HamsterSleepGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.hamster.m_21824_() || this.hamster.m_5803_() || this.hamster.m_21827_() || this.hamster.isKnockedOut()) {
            return false;
        }
        if (!this.hamster.m_9236_().m_46461_()) {
            return false;
        }
        if (!this.hamster.m_20096_()) {
            return false;
        }
        if (this.checkTimer > 0) {
            --this.checkTimer;
            return false;
        }
        this.checkTimer = 20;
        double radius = 5.0;
        boolean threatNearby = !this.hamster.m_9236_().m_6249_((Entity)this.hamster, this.hamster.m_20191_().m_82400_(radius), this::isThreat).isEmpty();
        return !threatNearby;
    }

    public void m_8056_() {
        SoundEvent sleepSound;
        this.hamster.m_21573_().m_26573_();
        this.hamster.m_6710_(null);
        this.hamster.setSleeping(true);
        this.hamster.m_21837_(true);
        if (!this.hamster.m_9236_().m_5776_()) {
            String settleAnimId;
            int choice = this.hamster.m_217043_().m_188503_(3);
            this.hamster.m_20088_().m_135381_(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)(switch (choice) {
                case 0 -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep1";
                    yield "anim_hamster_sleep_pose1";
                }
                case 1 -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep2";
                    yield "anim_hamster_sleep_pose2";
                }
                default -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep3";
                    yield "anim_hamster_sleep_pose3";
                }
            }));
            this.hamster.triggerAnimOnServer("mainController", settleAnimId);
        }
        if (!this.hamster.m_9236_().m_5776_() && (sleepSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.hamster.m_217043_())) != null) {
            this.hamster.m_9236_().m_5594_(null, this.hamster.m_20183_(), sleepSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean m_8045_() {
        if (this.hamster.m_21824_() || !this.hamster.m_9236_().m_46461_()) {
            return false;
        }
        if (this.checkTimer > 0) {
            --this.checkTimer;
            return true;
        }
        this.checkTimer = 20;
        double radius = 5.0;
        boolean threatNearby = !this.hamster.m_9236_().m_6249_((Entity)this.hamster, this.hamster.m_20191_().m_82400_(radius), this::isThreat).isEmpty();
        return !threatNearby;
    }

    public void m_8041_() {
        this.hamster.setSleeping(false);
        this.hamster.m_21837_(false);
        this.checkTimer = 0;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    private boolean isThreat(Entity entity) {
        if (entity instanceof Monster) {
            return true;
        }
        return entity instanceof Player;
    }
}

