/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterWanderAroundFarGoal
extends WaterAvoidingRandomStrollGoal {
    private final HamsterEntity hamster;
    private static final double BUFFED_WANDER_SPEED = 0.9;

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed) {
        super((PathfinderMob)hamster, speed);
        this.hamster = hamster;
        this.m_25746_(110);
    }

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed, float probability) {
        super((PathfinderMob)hamster, speed, probability);
        this.hamster = hamster;
        this.m_25746_(110);
    }

    public boolean m_8036_() {
        if (this.hamster.m_21827_() || this.hamster.m_5803_() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingChase()) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            if (this.f_25725_.m_217043_().m_188503_(3) != 0) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - On cooldown.", (Object)this.hamster.m_19879_());
                return false;
            }
            Vec3 target = this.m_7037_();
            if (target == null) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - No valid target found.", (Object)this.hamster.m_19879_());
                return false;
            }
            this.f_25726_ = target.f_82479_;
            this.f_25727_ = target.f_82480_;
            this.f_25728_ = target.f_82481_;
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): SUCCEEDED. Target: ({}, {}, {})", new Object[]{this.hamster.m_19879_(), String.format("%.2f", target.f_82479_), String.format("%.2f", target.f_82480_), String.format("%.2f", target.f_82481_)});
            return true;
        }
        boolean canStartNormal = super.m_8036_();
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Normal): Result: {}", (Object)this.hamster.m_19879_(), (Object)canStartNormal);
        return canStartNormal;
    }

    public boolean m_8045_() {
        if (this.hamster.hasGreenBeanBuff()) {
            return !this.hamster.m_21827_() && !this.hamster.m_5803_() && !this.hamster.isKnockedOut() && !this.f_25725_.m_21573_().m_26571_();
        }
        return super.m_8045_();
    }

    public void m_8037_() {
        if (this.hamster.hasGreenBeanBuff() && this.f_25725_.m_21573_().m_26571_()) {
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] tick (Zoomies): Navigation is idle. Finding new target.", (Object)this.hamster.m_19879_());
            Vec3 newTarget = this.m_7037_();
            if (newTarget != null) {
                this.f_25725_.m_21573_().m_26519_(newTarget.f_82479_, newTarget.f_82480_, newTarget.f_82481_, 0.9);
            }
        }
    }

    public void m_8056_() {
        double currentSpeed = this.hamster.hasGreenBeanBuff() ? 0.9 : this.f_25729_;
        this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, currentSpeed);
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.hamster.hasGreenBeanBuff() ? " (Zoomies)" : ""));
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] start: Goal has started. IsBuffed: {}", (Object)this.hamster.m_19879_(), (Object)this.hamster.hasGreenBeanBuff());
    }

    @Nullable
    protected Vec3 m_7037_() {
        if (this.hamster.hasGreenBeanBuff()) {
            return this.getPreciseZoomiesTarget().map(Vec3::m_82512_).orElse(null);
        }
        return super.m_7037_();
    }

    private Optional<BlockPos> getPreciseZoomiesTarget() {
        LivingEntity livingEntity = this.hamster.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return Optional.empty();
        }
        Player owner = (Player)livingEntity;
        double lastAngle = this.hamster.getLastZoomiesAngle();
        boolean isClockwise = this.hamster.getZoomiesIsClockwise();
        double angleStep = Math.toRadians(this.hamster.m_217043_().m_216332_(40, 70));
        double newAngle = isClockwise ? lastAngle + angleStep : lastAngle - angleStep;
        this.hamster.setLastZoomiesAngle(newAngle);
        int radiusModifier = this.hamster.getZoomiesRadiusModifier();
        double radius = this.hamster.m_217043_().m_216332_(3 + radiusModifier, 5 + radiusModifier);
        double targetX = owner.m_20185_() + radius * Math.cos(newAngle);
        double targetZ = owner.m_20189_() + radius * Math.sin(newAngle);
        BlockPos idealPos = new BlockPos((int)targetX, (int)this.hamster.m_20186_(), (int)targetZ);
        Optional<BlockPos> finalTargetPos = this.hamster.findSafeSpawnPosition(idealPos, this.hamster.m_9236_(), 2);
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] getPreciseZoomiesTarget:\n  - IsClockwise: {}\n  - LastAngle(rad): {}\n  - AngleStep(rad): {}\n  - NewAngle(rad): {}\n  - Radius: {}\n  - IdealPos: {}\n  - FinalTarget: {}", new Object[]{this.hamster.m_19879_(), isClockwise, String.format("%.2f", lastAngle), String.format("%.2f", angleStep), String.format("%.2f", newAngle), String.format("%.2f", radius), idealPos, finalTargetPos.map(Vec3i::toString).orElse("null")});
        return this.hamster.findSafeSpawnPosition(idealPos, this.hamster.m_9236_(), 2);
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] stop: Goal has stopped.", (Object)this.hamster.m_19879_());
    }
}

