/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Unique
    private static final EntityDataAccessor<CompoundTag> SHOULDER_HAMSTERS = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.f_46443_) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$initDataTracker(CallbackInfo ci) {
        this.f_19804_.m_135372_(SHOULDER_HAMSTERS, (Object)new CompoundTag());
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin writeNbt is RUNNING for entity {}.", (Object)this.m_19879_());
        CompoundTag shoulderPetsNbt = (CompoundTag)this.m_20088_().m_135370_(SHOULDER_HAMSTERS);
        if (!shoulderPetsNbt.m_128456_()) {
            nbt.m_128365_("ShoulderHamsters", (Tag)shoulderPetsNbt);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            ListTag mountOrderList = new ListTag();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)StringTag.m_129297_((String)location.name()));
            }
            nbt.m_128365_("MountOrderQueue", (Tag)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.m_128405_("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin readNbt is RUNNING for entity {}.", (Object)this.m_19879_());
        if (nbt.m_128425_("ShoulderHamster", 10)) {
            CompoundTag oldHamsterNbt = nbt.m_128469_("ShoulderHamster");
            if (!oldHamsterNbt.m_128456_()) {
                CompoundTag newShoulderPetsNbt = new CompoundTag();
                newShoulderPetsNbt.m_128365_(ShoulderLocation.RIGHT_SHOULDER.name(), (Tag)oldHamsterNbt);
                this.m_20088_().m_135381_(SHOULDER_HAMSTERS, (Object)newShoulderPetsNbt);
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.m_128473_("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.m_5446_().getString());
            }
        } else if (nbt.m_128425_("ShoulderHamsters", 10)) {
            this.m_20088_().m_135381_(SHOULDER_HAMSTERS, (Object)nbt.m_128469_("ShoulderHamsters"));
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.m_128425_("MountOrderQueue", 9)) {
            ListTag mountOrderList = nbt.m_128437_("MountOrderQueue", 8);
            for (Tag element : mountOrderList) {
                try {
                    this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.valueOf(element.m_7916_()));
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)element.m_7916_());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but an empty mount queue. Rebuilding queue...", (Object)this.m_5446_().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).m_128456_()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
            AdorableHamsterPets.LOGGER.info("Successfully rebuilt mount queue for player {}. New queue: {}", (Object)this.m_5446_().getString(), this.adorablehamsterpets$mountOrderQueue);
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.m_128425_("LastGoldMessageIndex", 3) ? nbt.m_128451_("LastGoldMessageIndex") : -1;
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onPlayerDisconnect(this.m_20148_());
        }
    }

    @Override
    @Unique
    public CompoundTag getShoulderHamster(ShoulderLocation location) {
        CompoundTag allShoulderPets = (CompoundTag)this.m_20088_().m_135370_(SHOULDER_HAMSTERS);
        return allShoulderPets.m_128469_(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, CompoundTag nbt) {
        CompoundTag allShoulderPets = new CompoundTag();
        allShoulderPets.m_128391_((CompoundTag)this.m_20088_().m_135370_(SHOULDER_HAMSTERS));
        if (nbt == null || nbt.m_128456_()) {
            allShoulderPets.m_128473_(location.name());
        } else {
            allShoulderPets.m_128365_(location.name(), (Tag)nbt);
        }
        this.m_20088_().m_135381_(SHOULDER_HAMSTERS, (Object)allShoulderPets);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        Player self = (Player)this;
        Level world = self.m_9236_();
        if (world.f_46443_) {
            return;
        }
        RandomSource random = world.m_213780_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isDiamondNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), SoundSource.NEUTRAL, 2.5f, 1.0f);
                            self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.diamond_nearby").m_130940_(ChatFormatting.AQUA), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.m_216332_(140, 200);
                            ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.creeper_detected").m_130940_(ChatFormatting.RED), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.m_216332_(100, 160);
                        ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                    }
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        ShoulderLocation locationToProcess;
        Player self = (Player)this;
        Level world = self.m_9236_();
        if (world.f_46443_ || this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        RandomSource random = world.m_213780_();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        CompoundTag shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.m_128456_()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). This may indicate a desync.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((ServerLevel)world, self, shoulderNbt);
        if (hamster == null) {
            AdorableHamsterPets.LOGGER.error("Failed to create hamster from NBT for slot {}. Clearing data.", (Object)locationToProcess);
            this.setShoulderHamster(locationToProcess, new CompoundTag());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        if (isThrow) {
            if (hamster.m_6162_()) {
                self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.baby_throw_refusal").m_130940_(ChatFormatting.RED), true);
                return;
            }
            long currentTime = world.m_46467_();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                self.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{minutes, seconds}).m_130940_(ChatFormatting.RED), true);
                return;
            }
            hamster.m_7678_(self.m_20185_(), self.m_20188_() - 0.1, self.m_20189_(), self.m_146908_(), self.m_146909_());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            Vec3 lookVec = self.m_20252_(1.0f);
            Vec3 throwVec = new Vec3(lookVec.f_82479_, lookVec.f_82480_ + (double)0.1f, lookVec.f_82481_).m_82541_();
            hamster.m_20256_(throwVec.m_82490_((double)throwSpeed));
            hamster.f_19812_ = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new CompoundTag());
        HamsterEntity.spawnFromNbt((ServerLevel)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            FriendlyByteBuf flightBuf = new FriendlyByteBuf(Unpooled.buffer());
            flightBuf.writeInt(hamster.m_19879_());
            FriendlyByteBuf throwBuf = new FriendlyByteBuf(Unpooled.buffer());
            throwBuf.writeInt(hamster.m_19879_());
            ServerPlayer player = (ServerPlayer)this;
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.StartFlightSoundS2CPacket(hamster.m_19879_()));
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.StartThrowSoundS2CPacket(hamster.m_19879_()));
            double radius = 64.0;
            Vec3 hamsterPos = hamster.m_20182_();
            AABB searchBox = new AABB(hamsterPos.m_82492_(radius, radius, radius), hamsterPos.m_82520_(radius, radius, radius));
            List nearbyPlayers = ((ServerLevel)world).m_8795_(p -> p != self && searchBox.m_82390_(p.m_20182_()));
            FriendlyByteBuf flightBufNearby = new FriendlyByteBuf(Unpooled.buffer());
            flightBufNearby.writeInt(hamster.m_19879_());
            FriendlyByteBuf throwBufNearby = new FriendlyByteBuf(Unpooled.buffer());
            throwBufNearby.writeInt(hamster.m_19879_());
            ModPackets.CHANNEL.sendToPlayers((Iterable)nearbyPlayers, (Object)new ModPackets.StartFlightSoundS2CPacket(hamster.m_19879_()));
            ModPackets.CHANNEL.sendToPlayers((Iterable)nearbyPlayers, (Object)new ModPackets.StartThrowSoundS2CPacket(hamster.m_19879_()));
            ModCriteria.HAMSTER_THROWN.trigger((ServerPlayer)self);
        } else {
            world.m_5594_(null, self.m_20183_(), (SoundEvent)ModSounds.HAMSTER_DISMOUNT.get(), SoundSource.PLAYERS, 0.7f, 1.0f + random.m_188501_() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.m_188503_(availableKeys.size()));
                }
                self.m_5661_((Component)Component.m_237115_((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Unique
    private boolean isDiamondNearby(Player player, double radius) {
        Level world = player.m_9236_();
        BlockPos center = player.m_20183_();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<BlockPos> exposedOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedOres = new ArrayList<BlockPos>();
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)center.m_7918_(-intRadius, -intRadius, -intRadius), (BlockPos)center.m_7918_(intRadius, intRadius, intRadius))) {
            BlockState state;
            if (!(checkPos.m_123331_((Vec3i)center) <= radius * radius) || !(state = world.m_8055_(checkPos)).m_60713_(Blocks.f_50089_) && !state.m_60713_(Blocks.f_152474_)) continue;
            if (HamsterSeekDiamondGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.m_7949_());
                continue;
            }
            buriedOres.add(checkPos.m_7949_());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(Player player, double radius) {
        AABB searchBox;
        Level world = player.m_9236_();
        List nearbyCreepers = world.m_6443_(Creeper.class, searchBox = new AABB(player.m_20182_().m_82492_(radius, radius, radius), player.m_20182_().m_82520_(radius, radius, radius)), creeper -> creeper.m_6084_() && creeper.m_5448_() == player && EntitySelector.f_20402_.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).m_128456_() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).m_128456_() || !this.getShoulderHamster(ShoulderLocation.HEAD).m_128456_();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        return this.adorablehamsterpets$clientShoulderData;
    }
}

