/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CloakRenderer
implements ICurioRenderer {
    private final ResourceLocation texture;
    private final HumanoidModel<LivingEntity> model;

    public CloakRenderer(String texturePath, HumanoidModel<LivingEntity> model) {
        this(new ResourceLocation("skillcloaks", String.format("textures/entity/curio/%s.png", texturePath)), model);
    }

    public CloakRenderer(ResourceLocation texture, HumanoidModel<LivingEntity> model) {
        this.texture = texture;
        this.model = model;
    }

    protected ResourceLocation getTexture() {
        return this.texture;
    }

    protected HumanoidModel<LivingEntity> getModel() {
        return this.model;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        HumanoidModel<LivingEntity> model = this.getModel();
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && slotContext.entity().m_20145_() && (CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)SkillcloaksItems.THIEVING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent())) {
            return;
        }
        if (ModList.get().isLoaded("caelus")) {
            if (!CaelusApi.getInstance().canFly(slotContext.entity())) {
                model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.m_6839_(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
                ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
                if (EnchantmentHelper.m_44831_((ItemStack)slotContext.entity().m_6844_(EquipmentSlot.CHEST)).isEmpty()) {
                    this.render(poseStack, multiBufferSource, light, stack.m_41790_());
                } else {
                    this.render(poseStack, multiBufferSource, light, true);
                }
            }
        } else if (!(slotContext.entity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem)) {
            model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.m_6839_(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
            ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
            if (EnchantmentHelper.m_44831_((ItemStack)slotContext.entity().m_6844_(EquipmentSlot.CHEST)).isEmpty()) {
                this.render(poseStack, multiBufferSource, light, stack.m_41790_());
            } else {
                this.render(poseStack, multiBufferSource, light, true);
            }
        }
    }

    protected void render(PoseStack matrixStack, MultiBufferSource buffer, int light, boolean hasFoil) {
        RenderType renderType = this.model.m_103119_(this.getTexture());
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        this.model.m_7695_(matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

