/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class DefenceCloakItem
extends CurioItem {
    private static final String TAG_DEFENCE_COOLDOWN = "preventDeath";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.defence_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @SubscribeEvent
    public static void onDamageEvent(LivingDamageEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            LivingEntity player = event.getEntity();
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (event.getAmount() >= event.getEntity().m_21223_() && (CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillcloaksItems.DEFENCE_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) && data.m_128451_(TAG_DEFENCE_COOLDOWN) <= 0) {
                event.setAmount(0.0f);
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                data.m_128405_(TAG_DEFENCE_COOLDOWN, Math.abs((Integer)SkillcloaksCommonConfig.DEFENCE_COOLDOWN.get()));
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (!player.m_9236_().f_46443_) {
            if (player.f_19797_ % 2 == 0 && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                data.m_128405_(TAG_DEFENCE_COOLDOWN, data.m_128451_(TAG_DEFENCE_COOLDOWN) - 1);
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
            if (data.m_128451_(TAG_DEFENCE_COOLDOWN) == 1) {
                player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.recharged"), true);
                player.m_6330_(SoundEvents.f_12616_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (data.m_128451_(TAG_DEFENCE_COOLDOWN) <= 0) {
                data.m_128473_(TAG_DEFENCE_COOLDOWN);
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (!player.m_9236_().f_46443_ && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                int totalSecs = data.m_128451_(TAG_DEFENCE_COOLDOWN) / 20;
                int days = totalSecs / 86400;
                int hours = totalSecs % 86400 / 3600;
                int mins = totalSecs % 3600 / 60;
                int secs = totalSecs % 60;
                if (days > 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(days + "d " + hours + "h " + mins + "m " + secs + "s"))), true);
                } else if (hours > 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(hours + "h " + mins + "m " + secs + "s"))), true);
                } else if (mins > 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(mins + "m " + secs + "s"))), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.skillcloaks.defence.cooldown").m_7220_((Component)Component.m_237113_((String)(secs + "s"))), true);
                }
                player.m_6330_((SoundEvent)SoundEvents.f_12217_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }
}

