/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class SmithingCloakItem
extends CurioItem {
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.smithing_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    private static BlastingRecipe getBlastingRecipe(Player player, Container inv) {
        return player.m_9236_().m_7465_().m_44015_(RecipeType.f_44109_, inv, player.m_9236_()).orElse(null);
    }

    @SubscribeEvent
    public static void onPlayerUseSmithingBlock(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.SMITHING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) {
            ItemStack mainHandItemStack = player.m_21205_();
            ItemStack offHandItemStack = player.m_21206_();
            SimpleContainer slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
            SimpleContainer slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
            BlastingRecipe recipe = SmithingCloakItem.getBlastingRecipe(player, (Container)slotInv);
            BlastingRecipe recipeOff = SmithingCloakItem.getBlastingRecipe(player, (Container)slotInvOff);
            if ((recipe != null || recipeOff != null) && (mainHandItemStack.m_41720_() instanceof FlintAndSteelItem || offHandItemStack.m_41720_() instanceof FlintAndSteelItem)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUseSmithing(PlayerInteractEvent.RightClickItem event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Level world = player.m_9236_();
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.SMITHING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) {
            ItemStack mainHandItemStack = player.m_21205_();
            ItemStack offHandItemStack = player.m_21206_();
            SimpleContainer slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
            SimpleContainer slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
            BlastingRecipe recipe = SmithingCloakItem.getBlastingRecipe(player, (Container)slotInv);
            BlastingRecipe recipeOff = SmithingCloakItem.getBlastingRecipe(player, (Container)slotInvOff);
            if ((recipe != null || recipeOff != null) && (mainHandItemStack.m_41720_() instanceof FlintAndSteelItem || offHandItemStack.m_41720_() instanceof FlintAndSteelItem)) {
                event.setCanceled(true);
                if (offHandItemStack.m_41720_() instanceof FlintAndSteelItem) {
                    int size = mainHandItemStack.m_41613_();
                    for (int i = 0; i < size; ++i) {
                        ItemStack result;
                        if (!(offHandItemStack.m_41720_() instanceof FlintAndSteelItem) || offHandItemStack.m_41773_() > offHandItemStack.m_41776_() || (result = recipe.m_5874_((Container)slotInv, world.m_9598_())).m_41619_()) continue;
                        mainHandItemStack.m_41774_(1);
                        ItemEntity drop = new ItemEntity(player.m_9236_(), player.m_20191_().m_82399_().f_82479_, player.m_20191_().m_82399_().f_82480_, player.m_20191_().m_82399_().f_82481_, result);
                        drop.m_20334_(0.0, 0.0, 0.0);
                        drop.m_32061_();
                        player.m_9236_().m_7967_((Entity)drop);
                        offHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.OFFHAND));
                    }
                    world.m_6263_(null, player.m_20191_().m_82399_().f_82479_, player.m_20191_().m_82399_().f_82480_, player.m_20191_().m_82399_().f_82481_, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (mainHandItemStack.m_41720_() instanceof FlintAndSteelItem) {
                    int size = offHandItemStack.m_41613_();
                    for (int i = 0; i < size; ++i) {
                        ItemStack result;
                        if (!(mainHandItemStack.m_41720_() instanceof FlintAndSteelItem) || mainHandItemStack.m_41773_() > mainHandItemStack.m_41776_() || (result = recipeOff.m_5874_((Container)slotInv, world.m_9598_())).m_41619_()) continue;
                        offHandItemStack.m_41774_(1);
                        ItemEntity drop = new ItemEntity(player.m_9236_(), player.m_20191_().m_82399_().f_82479_, player.m_20191_().m_82399_().f_82480_, player.m_20191_().m_82399_().f_82481_, result);
                        drop.m_20334_(0.0, 0.0, 0.0);
                        drop.m_32061_();
                        player.m_9236_().m_7967_((Entity)drop);
                        mainHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.MAINHAND));
                    }
                    world.m_6263_(null, player.m_20191_().m_82399_().f_82479_, player.m_20191_().m_82399_().f_82480_, player.m_20191_().m_82399_().f_82481_, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }
}

