/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.config.SkillcloaksCommonConfig;
import net.mindoth.skillcloaks.item.CurioItem;
import net.mindoth.skillcloaks.registries.SkillcloaksItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class WoodcuttingCloakItem
extends CurioItem {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skillcloaks.woodcutting_cloak"));
        }
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"curios.modifiers.cloak").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("+" + ((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).toString() + " ")).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)"tooltip.skillcloaks.armor_value")));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue() && (Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get() > 0) {
            result.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "cloak_armor").toString(), (double)((Integer)SkillcloaksCommonConfig.SKILL_CLOAK_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    private static List<BlockPos> getLogsToBreak(Level world, BlockPos pos, List<BlockPos> logsToBreak) {
        ArrayList<Object> checkAround = new ArrayList<Object>();
        Iterator aroundLogs = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 1)).iterator();
        while (aroundLogs.hasNext()) {
            BlockPos logPos = ((BlockPos)aroundLogs.next()).m_7949_();
            if (logsToBreak.contains(logPos) || !world.m_8055_(logPos).m_204336_(BlockTags.f_13106_)) continue;
            checkAround.add(logPos);
            logsToBreak.add(logPos);
        }
        if (checkAround.size() == 0) {
            return logsToBreak;
        }
        for (BlockPos blockPos : checkAround) {
            for (BlockPos logPos : WoodcuttingCloakItem.getLogsToBreak(world, blockPos, logsToBreak)) {
                if (logsToBreak.contains(logPos)) continue;
                logsToBreak.add(logPos.m_7949_());
            }
        }
        BlockPos up = pos.m_6630_(2);
        return WoodcuttingCloakItem.getLogsToBreak(world, up.m_7949_(), logsToBreak);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)SkillcloaksCommonConfig.COSMETIC_ONLY.get()).booleanValue()) {
            return;
        }
        Level world = event.getPlayer().m_9236_();
        if (!world.f_46443_ && (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)event.getPlayer(), (Item)SkillcloaksItems.WOODCUTTING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)event.getPlayer(), (Item)SkillcloaksItems.MAX_CLOAK.get()).isPresent()) && !event.getPlayer().m_6047_() && event.getState().m_204336_(BlockTags.f_13106_)) {
            List<BlockPos> logs = WoodcuttingCloakItem.getLogsToBreak(world, event.getPos(), new ArrayList<BlockPos>());
            ItemStack axeItem = event.getPlayer().m_6844_(EquipmentSlot.MAINHAND);
            int durability = axeItem.m_41776_() - axeItem.m_41773_();
            if (axeItem.m_41720_() instanceof AxeItem && durability >= logs.size()) {
                boolean isTree = false;
                for (BlockPos leafPos : logs) {
                    Stream aroundLogs = BlockPos.m_121886_((int)(leafPos.m_123341_() - 1), (int)(leafPos.m_123342_() - 1), (int)(leafPos.m_123343_() - 1), (int)(leafPos.m_123341_() + 1), (int)(leafPos.m_123342_() + 1), (int)(leafPos.m_123343_() + 1));
                    if (!aroundLogs.anyMatch(t -> world.m_8055_((BlockPos)new BlockPos.MutableBlockPos(t.m_123341_(), t.m_123342_(), t.m_123343_())).m_204336_(BlockTags.f_13035_) && world.m_8055_((BlockPos)new BlockPos.MutableBlockPos(t.m_123341_(), t.m_123342_(), t.m_123343_())).m_61138_((Property)PERSISTENT) && (Boolean)world.m_8055_((BlockPos)new BlockPos.MutableBlockPos(t.m_123341_(), t.m_123342_(), t.m_123343_())).m_61143_((Property)PERSISTENT) == false)) continue;
                    isTree = true;
                }
                if (isTree) {
                    for (BlockPos logPos : logs) {
                        world.m_8055_(logPos).m_60734_().m_6240_(world, event.getPlayer(), logPos, world.m_8055_(logPos), null, axeItem);
                        world.m_7471_(logPos, false);
                        axeItem.m_41622_(1, (LivingEntity)event.getPlayer(), holder -> holder.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
            } else {
                world.m_6263_(null, event.getPlayer().m_20185_(), event.getPlayer().m_20186_() + 1.0, event.getPlayer().m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }
}

