/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.large;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ElementProvider;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class LargeCreateStyled060Display
implements BogeyDisplay {
    private final Affine<?> frame;
    private final Affine<?> piston;
    private final Affine<?> semiBlindWheels;
    private final Affine<?>[] wheels;
    private final Affine<?>[] pins;
    private final Affine<?>[] secondaryShafts = new Affine[2];
    private final Affine<?>[] middleShafts = new Affine[4];

    public LargeCreateStyled060Display(ElementProvider<?> prov) {
        this.frame = prov.create(CRBlockPartials.LARGE_CREATE_STYLED_0_6_0_FRAME);
        this.piston = prov.create(CRBlockPartials.LARGE_CREATE_STYLED_0_6_0_PISTON);
        this.semiBlindWheels = prov.create(CRBlockPartials.LC_STYLE_SEMI_BLIND_WHEELS);
        this.wheels = prov.create(AllPartialModels.LARGE_BOGEY_WHEELS, 2);
        this.pins = prov.create(AllPartialModels.BOGEY_PIN, 3);
        prov.create(AllPartialModels.SHAFT, this.secondaryShafts, this.middleShafts);
    }

    @Override
    public void update(CompoundTag bogeyData, float wheelAngle) {
        for (int side : Iterate.positiveAndNegative) {
            ((Affine)((Affine)((Affine)((Affine)this.secondaryShafts[(side + 1) / 2].translate(-0.5, 0.25, -0.5 + (double)side * 2.681)).center()).rotateTo(Direction.UP, Direction.EAST)).rotateYDegrees(wheelAngle)).uncenter();
        }
        for (int side = -2; side <= 2; ++side) {
            if (side == 0) continue;
            int shaftNum = side > 0 ? side + 1 : side + 2;
            ((Affine)((Affine)((Affine)((Affine)this.middleShafts[shaftNum].translate(-0.5f, 0.25f, -0.5f + (float)side)).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter();
        }
        this.frame.self();
        this.piston.translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad((double)wheelAngle)));
        ((Affine)((Affine)this.semiBlindWheels.translate(0.0f, 1.0f, 0.0f)).rotateXDegrees(wheelAngle)).translate(0.0f, -1.0f, 0.0f);
        for (int side : Iterate.positiveAndNegative) {
            ((Affine)this.wheels[(side + 1) / 2].translate(0.0, 1.0, (double)side * 1.6842)).rotateXDegrees(wheelAngle);
        }
        for (int side = -1; side <= 1; ++side) {
            ((Affine)((Affine)((Affine)this.pins[side + 1].translate(0.0, 1.0, (double)side * 1.6842)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f)).rotateXDegrees(-wheelAngle);
        }
    }
}

