/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.schedule.WaypointDestinationInstruction;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScheduleRuntime.class}, remap=false)
public abstract class MixinScheduleRuntime {
    @Shadow
    public Schedule schedule;
    @Shadow
    public int currentEntry;
    @Shadow
    public ScheduleRuntime.State state;
    @Shadow
    public boolean isAutoSchedule;
    @Shadow
    public Train train;

    @Shadow
    public abstract void discardSchedule();

    @Inject(method={"tickConditions"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickWhenNoConditions(Level level, CallbackInfo ci) {
        if (((ScheduleEntry)this.schedule.entries.get((int)this.currentEntry)).conditions.isEmpty()) {
            this.state = ScheduleRuntime.State.PRE_TRANSIT;
            ++this.currentEntry;
            ci.cancel();
        }
    }

    @Inject(method={"checkEndOfScheduleReached"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;completed:Z", opcode=181, shift=At.Shift.AFTER)})
    private void discardAutoSchedule(CallbackInfoReturnable<Boolean> cir) {
        if (this.isAutoSchedule) {
            Railways.LOGGER.info("[DISCARD_SCHEDULE] on train {} called in MixinScheduleRuntime#discardAutoSchedule because a non-looping auto schedule was completed", (Object)this.train.name.getString());
            this.discardSchedule();
        }
    }

    @Inject(method={"estimateStayDuration"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/util/List;get(I)Ljava/lang/Object;", shift=At.Shift.BY, by=2)}, cancellable=true)
    private void waypointsAreValid(int index, CallbackInfoReturnable<Integer> cir, @Local(name={"scheduleEntry"}) ScheduleEntry scheduleEntry) {
        if (scheduleEntry.instruction instanceof WaypointDestinationInstruction) {
            cir.setReturnValue((Object)0);
        }
    }
}

