/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.capability;

import com.github.jarva.arsadditions.common.capability.NexusCapability;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

public class CapabilityRegistry {
    public static final Capability<ItemStackHandler> PLAYER_NEXUS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ItemStackHandler>(){});

    @Mod.EventBusSubscriber(modid="ars_additions")
    public static class CapabilityEventHandler {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            Object object = event.getObject();
            if (object instanceof Player) {
                Player player = (Player)object;
                event.addCapability(NexusCapability.IDENTIFIER, (ICapabilityProvider)new NexusCapability(player));
            }
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(NexusCapability.class);
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            Player old = event.getOriginal();
            old.reviveCaps();
            old.getCapability(PLAYER_NEXUS_CAPABILITY).ifPresent(oldCap -> event.getEntity().getCapability(PLAYER_NEXUS_CAPABILITY).ifPresent(newCap -> newCap.deserializeNBT(oldCap.serializeNBT())));
        }
    }
}

