/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.datagen.tags.ItemTagDatagen;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CodexEntry
extends Item {
    public CodexEntry() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return super.m_7203_(level, player, usedHand);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        IPlayerCap playerCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)player).orElse(null);
        if (playerCap == null) {
            return super.m_7203_(level, player, usedHand);
        }
        List<AbstractSpellPart> glyphs = this.getPossibleGlyphs(playerCap).filter(this::isValidGlyph).toList();
        if (glyphs.isEmpty()) {
            int i = this.getExpAmount(level.f_46441_);
            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)player.m_20182_(), (int)i);
            player.m_213846_((Component)Component.m_237115_((String)"chat.ars_additions.codex_entry.congratulations"));
            player.m_213846_((Component)Component.m_237115_((String)"chat.ars_additions.codex_entry.no_glyphs"));
        } else {
            AbstractSpellPart glyph = this.getRandomGlyph(glyphs, level.f_46441_);
            playerCap.unlockGlyph(glyph);
            CapabilityRegistry.EventHandler.syncPlayerCap((Player)player);
            player.m_213846_((Component)Component.m_237113_((String)("Unlocked " + glyph.getName())));
        }
        player.m_21120_(usedHand).m_41774_(1);
        return super.m_7203_(level, player, usedHand);
    }

    public AbstractSpellPart getRandomGlyph(List<AbstractSpellPart> glyphs, RandomSource random) {
        return glyphs.get(random.m_216339_(0, glyphs.size()));
    }

    public Stream<AbstractSpellPart> getPossibleGlyphs(IPlayerCap playerCap) {
        List startingSpells = GlyphRegistry.getDefaultStartingSpells();
        return GlyphRegistry.getSpellpartMap().values().stream().filter(Config::isGlyphEnabled).filter(glyph -> !new ItemStack((ItemLike)glyph.getGlyph()).m_204117_(ItemTagDatagen.FORGOTTEN_KNOWLEDGE_GLYPHS)).filter(glyph -> !startingSpells.contains(glyph)).filter(glyph -> !playerCap.knowsGlyph(glyph));
    }

    public int getExpAmount(RandomSource random) {
        return 55;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237110_((String)"chat.ars_additions.codex_entry.lore", (Object[])new Object[]{this.getTier().value}));
    }

    public SpellTier getTier() {
        return SpellTier.ONE;
    }

    public boolean isValidGlyph(AbstractSpellPart glyph) {
        return glyph.getConfigTier() == this.getTier();
    }
}

