/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.imbuement;

import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record ImbueSpellScrollRecipe(ResourceLocation id) implements IImbuementRecipe
{
    public boolean isMatch(ImbuementTile imbuementTile) {
        if (imbuementTile.getPedestalItems().isEmpty()) {
            return false;
        }
        ItemStack reagent = imbuementTile.stack;
        if (!reagent.m_150930_((Item)ItemsRegistry.SPELL_PARCHMENT.get())) {
            return false;
        }
        ISpellCaster reagentCaster = CasterUtil.getCaster((ItemStack)reagent);
        return reagentCaster.getSpell().isValid();
    }

    public ItemStack getResult(ImbuementTile imbuementTile) {
        ItemStack result = new ItemStack((ItemLike)AddonItemRegistry.IMBUED_SPELL_PARCHMENT.get());
        result.m_41751_(imbuementTile.stack.m_41783_());
        return result;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.stack;
        ISpellCaster reagentCaster = CasterUtil.getCaster((ItemStack)reagent);
        return reagentCaster.getSpell().getCost() * 10;
    }

    public boolean matches(ImbuementTile container, Level level) {
        return false;
    }

    public ItemStack assemble(ImbuementTile container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AddonRecipeRegistry.IMBUE_SCROLL_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AddonRecipeRegistry.IMBUE_SCROLL_TYPE.get();
    }

    public JsonElement asRecipe() {
        JsonElement recipe = Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        JsonObject obj = recipe.getAsJsonObject();
        obj.addProperty("type", this.m_6671_().toString());
        return obj;
    }

    public static class Serializer
    implements RecipeSerializer<ImbueSpellScrollRecipe> {
        public static final Codec<ImbueSpellScrollRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(ImbueSpellScrollRecipe::id)).apply((Applicative)instance, ImbueSpellScrollRecipe::new));

        public ImbueSpellScrollRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(null);
        }

        @Nullable
        public ImbueSpellScrollRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (ImbueSpellScrollRecipe)friendlyByteBuf.m_271872_(CODEC);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, ImbueSpellScrollRecipe recipe) {
            friendlyByteBuf.m_272073_(CODEC, (Object)recipe);
        }
    }
}

