/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.ritual;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.recipes.LocateStructureRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RitualLocateStructure
extends AbstractRitual {
    @Nullable
    private Optional<LocateStructureRecipe> recipe;
    public static ResourceLocation RESOURCE_LOCATION = ArsAdditions.prefix("ritual_locate_structure");

    private Optional<LocateStructureRecipe> getRecipe() {
        return LocateStructureRegistry.INSTANCE.getRecipes().stream().filter(r -> r.matches(this.getConsumedItems())).findFirst();
    }

    protected void tick() {
        Level world = this.getWorld();
        if (world == null || this.getPos() == null) {
            return;
        }
        if (this.recipe == null) {
            this.recipe = this.getRecipe();
        }
        if (this.recipe.isEmpty()) {
            for (ItemStack consumedItem : this.getConsumedItems()) {
                this.dispenseItem(world, consumedItem, this.getPos());
            }
            this.setFinished();
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        LocateStructureRecipe locator = this.recipe.get();
        LocateUtil.locate(serverLevel, locator.getStructureHolder(serverLevel), this.getPos(), locator.getRadius(), locator.getSkipExisting(), pair -> {
            if (pair == null) {
                for (ItemStack consumedItem : this.getConsumedItems()) {
                    this.dispenseItem(world, consumedItem, this.getPos());
                }
                this.dispenseItem(world, new ItemStack((ItemLike)RitualRegistry.getRitualItemMap().get(this.getRegistryName())), this.getPos());
                this.setFinished();
                return;
            }
            BlockPos pos = (BlockPos)pair.getFirst();
            Holder structure = (Holder)pair.getSecond();
            ItemStack wayfinder = new ItemStack((ItemLike)AddonItemRegistry.WAYFINDER.get(), 1);
            CompoundTag wayfinderTag = wayfinder.m_41784_();
            structure.m_203543_().map(key -> LangUtil.toTitleCase(key.m_135782_().m_135815_())).ifPresent(component -> wayfinderTag.m_128359_("Structure", Component.Serializer.m_130703_((Component)component)));
            GlobalPos global = GlobalPos.m_122643_((ResourceKey)serverLevel.m_46472_(), (BlockPos)pos);
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)global).result().ifPresent(tag -> wayfinderTag.m_128365_("Locator", tag));
            this.dispenseItem(world, wayfinder, this.getPos());
            this.setFinished();
        });
    }

    private void dispenseItem(Level level, ItemStack stack, BlockPos pos) {
        Direction facing = Direction.UP;
        double x = (double)pos.m_123341_() + 0.7 * (double)facing.m_122429_();
        double y = (double)pos.m_123342_() + 0.7 * (double)facing.m_122430_() - 0.125;
        double z = (double)pos.m_123343_() + 0.7 * (double)facing.m_122431_();
        ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack);
        double g = level.f_46441_.m_188500_() * 0.1 + 0.2;
        itemEntity.m_20334_(level.f_46441_.m_216328_((double)facing.m_122429_() * g, 0.103365), level.f_46441_.m_216328_(0.2, 0.103365), level.f_46441_.m_216328_((double)facing.m_122431_() * g, 0.103365));
        level.m_7967_((Entity)itemEntity);
    }

    public void onStart(@Nullable Player player) {
        super.onStart(player);
    }

    public boolean canStart(@Nullable Player player) {
        this.recipe = this.getRecipe();
        return this.recipe.isPresent();
    }

    public boolean canConsumeItem(ItemStack stack) {
        return true;
    }

    public String getLangName() {
        return "Locate Structure";
    }

    public String getLangDescription() {
        return "Locate a nearby structure based on the augments.";
    }

    public ResourceLocation getRegistryName() {
        return RESOURCE_LOCATION;
    }
}

