/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.datagen.Setup;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EnchantingAppDatagen
extends ApparatusRecipeProvider {
    public EnchantingAppDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/" + Setup.root + "/recipes/apparatus/" + str + ".json");
    }

    public void collectJsons(CachedOutput cache) {
        this.addEntries();
        for (EnchantingApparatusRecipe g : this.recipes) {
            Path path = EnchantingAppDatagen.getRecipePath(this.output, g.id.m_135815_());
            this.saveStable(cache, g.asRecipe(), path);
        }
    }

    public void addEntries() {
        this.addRecipe(this.builder().withResult(AddonItemRegistry.LECTERN_REMOTE).withReagent((ItemLike)ItemsRegistry.MUNDANE_BELT).withPedestalItem(1, (ItemLike)ItemsRegistry.SCRY_CASTER).withPedestalItem(1, (ItemLike)BlockRegistry.SCRYERS_CRYSTAL).withPedestalItem(1, (ItemLike)ItemsRegistry.STARBUNCLE_CHARM).withPedestalItem(1, (ItemLike)ItemsRegistry.BOOKWYRM_CHARM).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.ADVANCED_LECTERN_REMOTE).withReagent(AddonItemRegistry.LECTERN_REMOTE).withPedestalItem(1, (ItemLike)Items.f_42418_).withPedestalItem(1, (ItemLike)Items.f_42686_).withPedestalItem(1, (ItemLike)Blocks.f_50265_).build());
        this.addRecipe(this.builder().withResult(AddonBlockRegistry.ENDER_SOURCE_JAR).withReagent((ItemLike)BlockRegistry.SOURCE_JAR).withPedestalItem(4, (ItemLike)Items.f_42584_).withPedestalItem(4, (ItemLike)Items.f_42731_).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.UNSTABLE_RELIQUARY).withReagent((ItemLike)BlockRegistry.MOB_JAR).withPedestalItem(1, (ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)Items.f_42584_).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.XP_JAR).withReagent((ItemLike)Items.f_42590_).withPedestalItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withPedestalItem((ItemLike)Blocks.f_50094_).withPedestalItem((ItemLike)Blocks.f_50652_).withPedestalItem(Ingredient.m_204132_((TagKey)ItemTags.f_13160_)).withPedestalItem((ItemLike)Items.f_42534_).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.ADVANCED_DOMINION_WAND).withReagent((ItemLike)ItemsRegistry.DOMINION_ROD).withPedestalItem((ItemLike)Items.f_150998_).withPedestalItem((ItemLike)Items.f_42417_).withPedestalItem((ItemLike)Items.f_42417_).build());
        this.addRecipe(this.builder().withResult((ItemLike)AddonBlockRegistry.SOURCE_SPAWNER.get()).withReagent((ItemLike)ItemsRegistry.DRYGMY_CHARM).withPedestalItem((ItemLike)ItemsRegistry.SUMMONING_FOCUS).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).build());
        for (CharmRegistry.CharmType charmType : CharmRegistry.CharmType.values()) {
            ApparatusRecipeBuilder builder = this.builder().withResult(AddonItemRegistry.CHARMS.get((Object)charmType)).withReagent((ItemLike)Items.f_42590_);
            for (ItemLike item : charmType.getPedestalItems()) {
                builder.withPedestalItem(item);
            }
            this.addRecipe(builder.build());
        }
    }
}

