/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="ars_additions")
public class ModifyTagRegistry {
    private static final Codec<Codec<? extends TagModifier>> DIRECT_CODEC = ResourceLocation.f_135803_.xmap(id -> (Codec)ModifyTagRegistry.getTagModifierRegistry().getValue(id), codec -> ModifyTagRegistry.getTagModifierRegistry().getKey(codec));
    public static final Codec<TagModifier> CODEC = DIRECT_CODEC.dispatch(TagModifier::type, Function.identity());
    public static final ResourceKey<Registry<Codec<? extends TagModifier>>> TAG_MODIFIER_KEY = ResourceKey.m_135788_((ResourceLocation)ArsAdditions.prefix("tag_modifier"));
    public static DeferredRegister<Codec<? extends TagModifier>> TAG_MODIFIER_DEFERRED = DeferredRegister.create(TAG_MODIFIER_KEY, (String)"ars_additions");
    private static IForgeRegistry<Codec<? extends TagModifier>> tagModifierRegistry;
    private static final RegistryObject<Codec<RemoveGuaranteedHandDrops>> REMOVE_GUARANTEED_HAND_DROPS;
    private static final RegistryObject<Codec<RemoveTag>> REMOVE_TAG;
    private static final RegistryObject<Codec<SetTag>> SET_TAG;
    private static final RegistryObject<Codec<AppendTag>> APPEND_TAG;

    public static IForgeRegistry<Codec<? extends TagModifier>> getTagModifierRegistry() {
        return tagModifierRegistry;
    }

    @SubscribeEvent
    public static void AddRegistryEvent(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(TAG_MODIFIER_KEY.m_135782_()).disableSaving().allowModification(), b -> {
            tagModifierRegistry = b;
        });
    }

    static {
        REMOVE_GUARANTEED_HAND_DROPS = TAG_MODIFIER_DEFERRED.register("remove_guaranteed_hand_drops", () -> RemoveGuaranteedHandDrops.CODEC);
        REMOVE_TAG = TAG_MODIFIER_DEFERRED.register("remove_tag", () -> RemoveTag.CODEC);
        SET_TAG = TAG_MODIFIER_DEFERRED.register("set_tag", () -> SetTag.CODEC);
        APPEND_TAG = TAG_MODIFIER_DEFERRED.register("append_tag", () -> AppendTag.CODEC);
    }

    public record AppendTag(Map<String, Tag> append) implements TagModifier
    {
        private static final Codec<Tag> TAG_CODEC = Codec.PASSTHROUGH.xmap(dynamic -> (Tag)dynamic.convert((DynamicOps)NbtOps.f_128958_).getValue(), tag -> new Dynamic((DynamicOps)NbtOps.f_128958_, tag));
        public static final Codec<AppendTag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TAG_CODEC).fieldOf("append").forGetter(AppendTag::append)).apply((Applicative)instance, AppendTag::new));

        public Codec<AppendTag> type() {
            return (Codec)APPEND_TAG.get();
        }

        private void appendTag(CompoundTag nbt, ArrayDeque<String> compounds, Tag value) {
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                ListTag list = nbt.m_128437_(first, (int)value.m_7060_());
                list.add((Object)value);
                nbt.m_128365_(first, (Tag)list);
                return;
            }
            this.appendTag(nbt.m_128469_(first), compounds, value);
        }

        @Override
        public void modify(CompoundTag nbt) {
            for (Map.Entry<String, Tag> entry : this.append().entrySet()) {
                String tag = entry.getKey();
                Tag value = entry.getValue();
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.appendTag(nbt, compounds, value);
            }
        }
    }

    public record SetTag(Map<String, Tag> set) implements TagModifier
    {
        private static final Codec<Tag> TAG_CODEC = Codec.PASSTHROUGH.xmap(dynamic -> (Tag)dynamic.convert((DynamicOps)NbtOps.f_128958_).getValue(), tag -> new Dynamic((DynamicOps)NbtOps.f_128958_, tag));
        public static final Codec<SetTag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TAG_CODEC).fieldOf("set").forGetter(SetTag::set)).apply((Applicative)instance, SetTag::new));

        public Codec<SetTag> type() {
            return (Codec)SET_TAG.get();
        }

        private void setTag(CompoundTag nbt, ArrayDeque<String> compounds, Tag value) {
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                nbt.m_128365_(first, value);
                return;
            }
            this.setTag(nbt.m_128469_(first), compounds, value);
        }

        @Override
        public void modify(CompoundTag nbt) {
            for (Map.Entry<String, Tag> entry : this.set().entrySet()) {
                String tag = entry.getKey();
                Tag value = entry.getValue();
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.setTag(nbt, compounds, value);
            }
        }
    }

    public record RemoveTag(List<String> strip) implements TagModifier
    {
        public static Codec<RemoveTag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("strip_tags").forGetter(RemoveTag::strip)).apply((Applicative)instance, RemoveTag::new));

        public Codec<RemoveTag> type() {
            return (Codec)REMOVE_TAG.get();
        }

        private void removeTag(CompoundTag nbt, ArrayDeque<String> compounds) {
            if (nbt.m_128456_()) {
                return;
            }
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                nbt.m_128473_(first);
                return;
            }
            this.removeTag(nbt.m_128469_(first), compounds);
        }

        @Override
        public void modify(CompoundTag nbt) {
            for (String tag : this.strip()) {
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.removeTag(nbt, compounds);
            }
        }
    }

    public record RemoveGuaranteedHandDrops() implements TagModifier
    {
        public static Codec<RemoveGuaranteedHandDrops> CODEC = Codec.unit(RemoveGuaranteedHandDrops::new);

        public Codec<RemoveGuaranteedHandDrops> type() {
            return (Codec)REMOVE_GUARANTEED_HAND_DROPS.get();
        }

        private void removeGuaranteedDrops(CompoundTag tag, String key) {
            if (!tag.m_128441_(key)) {
                return;
            }
            ListTag list = tag.m_128437_(key, 5);
            for (int i = 0; i < list.size(); ++i) {
                float chance = list.m_128775_(i);
                if (chance != 2.0f) continue;
                list.set(i, (Tag)FloatTag.m_128566_((float)-327.67f));
            }
        }

        @Override
        public void modify(CompoundTag nbt) {
            this.removeGuaranteedDrops(nbt, "HandDropChances");
            this.removeGuaranteedDrops(nbt, "ArmorDropChances");
        }
    }
}

