/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.modules.config.annotations.IgnoreProp;
import it.hurts.octostudios.octolib.modules.config.impl.OctoConfig;
import it.hurts.sskirillss.relics.config.data.AbilitiesConfigData;
import it.hurts.sskirillss.relics.config.data.LevelingConfigData;
import it.hurts.sskirillss.relics.config.data.LootConfigData;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;

public class RelicConfigData
implements OctoConfig {
    @IgnoreProp
    private IRelicItem relic;
    private AbilitiesConfigData abilitiesData;
    private LevelingConfigData levelingData;
    private LootConfigData lootData;

    public RelicConfigData(IRelicItem relic) {
        this.relic = relic;
        this.setAbilitiesData(relic.getAbilitiesData().toConfigData());
        this.setLevelingData(relic.getLevelingData().toConfigData());
        this.setLootData(relic.getLootData().toConfigData());
    }

    public RelicData toData(IRelicItem relic) {
        RelicData data = relic.getRelicData();
        data.setAbilities(this.abilitiesData.toData(relic));
        data.setLeveling(this.levelingData.toData(relic));
        data.setLoot(this.lootData.toData(relic));
        return data;
    }

    public void onLoadObject(Object object) {
        this.relic.setRelicData(((RelicConfigData)object).toData(this.relic));
    }

    public IRelicItem getRelic() {
        return this.relic;
    }

    public AbilitiesConfigData getAbilitiesData() {
        return this.abilitiesData;
    }

    public LevelingConfigData getLevelingData() {
        return this.levelingData;
    }

    public LootConfigData getLootData() {
        return this.lootData;
    }

    public void setRelic(IRelicItem relic) {
        this.relic = relic;
    }

    public void setAbilitiesData(AbilitiesConfigData abilitiesData) {
        this.abilitiesData = abilitiesData;
    }

    public void setLevelingData(LevelingConfigData levelingData) {
        this.levelingData = levelingData;
    }

    public void setLootData(LootConfigData lootData) {
        this.lootData = lootData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicConfigData)) {
            return false;
        }
        RelicConfigData other = (RelicConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IRelicItem this$relic = this.getRelic();
        IRelicItem other$relic = other.getRelic();
        if (this$relic == null ? other$relic != null : !this$relic.equals(other$relic)) {
            return false;
        }
        AbilitiesConfigData this$abilitiesData = this.getAbilitiesData();
        AbilitiesConfigData other$abilitiesData = other.getAbilitiesData();
        if (this$abilitiesData == null ? other$abilitiesData != null : !((Object)this$abilitiesData).equals(other$abilitiesData)) {
            return false;
        }
        LevelingConfigData this$levelingData = this.getLevelingData();
        LevelingConfigData other$levelingData = other.getLevelingData();
        if (this$levelingData == null ? other$levelingData != null : !((Object)this$levelingData).equals(other$levelingData)) {
            return false;
        }
        LootConfigData this$lootData = this.getLootData();
        LootConfigData other$lootData = other.getLootData();
        return !(this$lootData == null ? other$lootData != null : !((Object)this$lootData).equals(other$lootData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelicConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IRelicItem $relic = this.getRelic();
        result = result * 59 + ($relic == null ? 43 : $relic.hashCode());
        AbilitiesConfigData $abilitiesData = this.getAbilitiesData();
        result = result * 59 + ($abilitiesData == null ? 43 : ((Object)$abilitiesData).hashCode());
        LevelingConfigData $levelingData = this.getLevelingData();
        result = result * 59 + ($levelingData == null ? 43 : ((Object)$levelingData).hashCode());
        LootConfigData $lootData = this.getLootData();
        result = result * 59 + ($lootData == null ? 43 : ((Object)$lootData).hashCode());
        return result;
    }

    public String toString() {
        return "RelicConfigData(relic=" + String.valueOf(this.getRelic()) + ", abilitiesData=" + String.valueOf(this.getAbilitiesData()) + ", levelingData=" + String.valueOf(this.getLevelingData()) + ", lootData=" + String.valueOf(this.getLootData()) + ")";
    }

    public RelicConfigData() {
    }
}

