/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.client.objects;

import com.c2h6s.etstlib.mixinUtil.ITinkerStationScreenMixin;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TinkerStationScrollingWidget
extends AbstractWidget
implements Renderable,
GuiEventListener {
    public final int innerHeight;
    public final ITinkerStationScreenMixin screen;
    private static final int BORDER_COLOR_FOCUSED = -1;
    private static final int BORDER_COLOR = -6250336;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int INNER_PADDING = 4;
    private double scrollAmount;
    private boolean scrolling;

    public TinkerStationScrollingWidget(ITinkerStationScreenMixin screen, int pX, int pY, int pWidth, int pHeight, Component pMessage, int innerHeight) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.innerHeight = innerHeight;
        this.screen = screen;
    }

    public int getScrollAmount() {
        return (int)this.scrollAmount();
    }

    protected int getInnerHeight() {
        return this.innerHeight;
    }

    protected double scrollRate() {
        return Math.min((float)(this.getContentHeight() - this.f_93619_) / 10.0f, 15.0f);
    }

    protected void setScrollAmount(double pScrollAmount) {
        this.scrollAmount = Mth.m_14008_((double)pScrollAmount, (double)0.0, (double)this.getMaxScrollAmount());
        if (this.screen.etstlib$getButtonsScreen() != null) {
            this.screen.etstlib$getButtonsScreen().setButtonPositions();
        }
    }

    protected void renderBorder(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight) {
        int i = this.m_93696_() ? -1 : -6250336;
        pGuiGraphics.m_280509_(pX - 1, pY, pX + 9, pY + pHeight, i);
        pGuiGraphics.m_280509_(pX, pY + 1, pX + 8, pY + pHeight - 1, -16777216);
    }

    public void renderScrollBar(GuiGraphics pGuiGraphics) {
        int barHeight = this.getScrollBarHeight();
        int startX = this.m_252754_();
        int endX = this.m_252754_() + 8;
        int barY = Math.max(this.m_252907_(), (int)this.scrollAmount * (this.f_93619_ - barHeight) / this.getMaxScrollAmount() + this.m_252907_());
        int endY = barY + barHeight;
        pGuiGraphics.m_280509_(startX, barY, endX, endY, -8355712);
        pGuiGraphics.m_280509_(startX, barY, endX - 1, endY - 1, -4144960);
    }

    protected void renderContents(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.f_93624_) {
            return false;
        }
        boolean within = this.withinContentAreaPoint(pMouseX, pMouseY);
        if (within && pButton == 0) {
            this.scrolling = true;
            return true;
        }
        return within;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.f_93624_ && this.m_93696_() && this.scrolling) {
            if (pMouseY < (double)this.m_252907_()) {
                this.setScrollAmount(0.0);
            } else if (pMouseY > (double)(this.m_252907_() + this.f_93619_)) {
                this.setScrollAmount(this.getMaxScrollAmount());
            } else {
                int $$5 = this.getScrollBarHeight();
                double $$6 = Math.max(1, this.getMaxScrollAmount() / (this.f_93619_ - $$5));
                this.setScrollAmount(this.scrollAmount + pDragY * $$6);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.f_93624_) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - pDelta * this.scrollRate());
        return true;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean $$4;
        boolean $$3 = pKeyCode == 265;
        boolean bl = $$4 = pKeyCode == 264;
        if ($$3 || $$4) {
            double $$5 = this.scrollAmount;
            this.setScrollAmount(this.scrollAmount + (double)($$3 ? -1 : 1) * this.scrollRate());
            if ($$5 != this.scrollAmount) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_93624_) {
            this.renderBackground(pGuiGraphics);
            pGuiGraphics.m_280588_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85837_(0.0, -this.scrollAmount, 0.0);
            this.renderContents(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            pGuiGraphics.m_280168_().m_85849_();
            pGuiGraphics.m_280618_();
            this.renderDecorations(pGuiGraphics);
        }
    }

    private int getScrollBarHeight() {
        return Mth.m_14045_((int)((int)((float)(this.f_93619_ * this.f_93619_) / (float)this.getContentHeight())), (int)32, (int)this.f_93619_);
    }

    protected void renderDecorations(GuiGraphics pGuiGraphics) {
        if (this.scrollbarVisible()) {
            this.renderScrollBar(pGuiGraphics);
        }
    }

    protected int innerPadding() {
        return 4;
    }

    protected int totalInnerPadding() {
        return this.innerPadding() * 2;
    }

    protected double scrollAmount() {
        return this.scrollAmount;
    }

    protected int getMaxScrollAmount() {
        return Math.max(0, this.getContentHeight() - (this.f_93619_ - 4));
    }

    private int getContentHeight() {
        return this.getInnerHeight() + 4;
    }

    protected void renderBackground(GuiGraphics pGuiGraphics) {
        this.renderBorder(pGuiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
    }

    protected boolean withinContentAreaTopBottom(int pTop, int pBottom) {
        return (double)pBottom - this.scrollAmount >= (double)this.m_252907_() && (double)pTop - this.scrollAmount <= (double)(this.m_252907_() + this.f_93619_);
    }

    protected boolean withinContentAreaPoint(double pX, double pY) {
        return pX >= (double)this.m_252754_() && pX < (double)(this.m_252754_() + this.f_93618_) && pY >= (double)this.m_252907_() && pY < (double)(this.m_252907_() + this.f_93619_);
    }

    protected boolean scrollbarVisible() {
        return this.getInnerHeight() > this.m_93694_();
    }
}

