/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.mixin;

import com.c2h6s.etstlib.content.misc.entityTicker.EntityTickerManager;
import com.c2h6s.etstlib.content.misc.vibration.ToolVibrationListener;
import com.c2h6s.etstlib.entity.specialDamageSources.interfaces.IConditionalHurt;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"updateDynamicGameEventListener"})
    public void addVibrationListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer, CallbackInfo ci) {
        ServerPlayer player;
        Level level;
        Entity entity = (Entity)this;
        if (entity instanceof ServerPlayer && (level = (player = (ServerPlayer)entity).m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ToolVibrationListener.validate((Player)player);
            if (ToolVibrationListener.listenerMap.get(player) != null) {
                pListenerConsumer.accept(new DynamicGameEventListener((GameEventListener)ToolVibrationListener.listenerMap.get(player).getListener()), level2);
            }
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelHurt(DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        IConditionalHurt conditional;
        Entity entity = (Entity)this;
        if (pSource instanceof IConditionalHurt && (conditional = (IConditionalHurt)pSource).canHurtEntity(entity) != null) {
            cir.setReturnValue((Object)conditional.canHurtEntity(entity));
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")})
    public void removeFromTickerMap(Entity.RemovalReason pRemovalReason, CallbackInfo ci) {
        Entity entity = (Entity)this;
        EntityTickerManager.TICKER_MAP.remove(entity);
    }
}

