/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.Common;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.content.misc.vibration.VibrationContext;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.VibrationListeningModifierHook;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class Resonating
extends EtSTBaseModifier
implements VibrationListeningModifierHook {
    public static final UUID RESONATING_UUID = UUID.fromString("a9869566-5540-d75f-5d12-b5b0393fc87e");
    public static final String KEY_FREQ = "resonating";
    public static final ResourceLocation KEY = EtSTLib.getResourceLocation("resonating");
    public static final List<MobEffect> effectList = List.of(MobEffects.f_19600_, MobEffects.f_19598_, MobEffects.f_19617_, MobEffects.f_19621_, MobEffects.f_19606_, MobEffects.f_19618_, MobEffects.f_19601_);

    @Override
    @NotNull
    public Component getDisplayName(int level) {
        return super.getDisplayName(level);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, EtSTLibHooks.VIBRATION_LISTENING, ModifierHooks.EQUIPMENT_CHANGE);
    }

    @Override
    public void onAcceptorTick(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, int acceptorLevel) {
        if (tool.getPersistentData().getInt(KEY) > 0) {
            tool.getPersistentData().putInt(KEY, tool.getPersistentData().getInt(KEY) - 1);
        }
        if (level.m_46467_() % 40L == 0L && player.getPersistentData().m_128451_(KEY_FREQ) > 0) {
            int bonus = player.getPersistentData().m_128451_(KEY_FREQ) / 10;
            player.getPersistentData().m_128405_(KEY_FREQ, 0);
            bonus = Math.min(bonus, 6);
            for (int i = 0; i < bonus; ++i) {
                int effectLevel = (acceptorLevel - 1) / 2;
                effectLevel = Math.min(5, effectLevel);
                MobEffect effect = effectList.get(i);
                if (effect == MobEffects.f_19606_ || effect == MobEffects.f_19601_) {
                    effectLevel = Math.min(2, effectLevel);
                }
                player.m_7292_(new MobEffectInstance(effect, 60, effectLevel, false, false));
            }
        }
    }

    @Override
    public UUID getAcceptorUUID(IToolStackView tool, ModifierEntry modifier, Player player, Level level, EquipmentSlot slot) {
        return RESONATING_UUID;
    }

    @Override
    public int listenRange(IToolStackView tool, ModifierEntry modifier, Player player, Level level, EquipmentSlot slot, int range) {
        return 16;
    }

    @Override
    public boolean canReceiveVibration(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, VibrationContext context) {
        if (context.directEntity == player) {
            return false;
        }
        return tool.getPersistentData().getInt(KEY) <= 0;
    }

    @Override
    public void onReceivingVibration(IToolStackView tool, ModifierEntry modifier, Player player, ServerLevel level, EquipmentSlot slot, VibrationContext context) {
        CompoundTag nbt = player.getPersistentData();
        nbt.m_128405_(KEY_FREQ, nbt.m_128451_(KEY_FREQ) + context.frequency);
        tool.getPersistentData().putInt(KEY, 40);
    }
}

