/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.capabilityProvider.PnCIntegration;

import com.c2h6s.etstlib.register.EtSTLibToolStat;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class AirStorageProvider
implements ToolCapabilityProvider.IToolCapabilityProvider,
IPressurizableItem {
    public final Supplier<? extends IToolStackView> tool;
    public final LazyOptional<IPressurizableItem> capOptional;
    public final float maxPressure;
    public final LazyOptional<IAirHandlerItem> airHandlerItemLazyOptional;
    public static final ResourceLocation LOCATION_AIR_STORAGE = new ResourceLocation("etstlib", "air");
    public final AirHandlerItemStack airHandlerItemStack;

    public AirStorageProvider(ItemStack stack, final Supplier<? extends IToolStackView> tool) {
        this.tool = tool;
        this.capOptional = LazyOptional.of(() -> this);
        this.maxPressure = ((Float)tool.get().getStats().get((IToolStat)EtSTLibToolStat.MAX_PRESSURE)).floatValue();
        this.airHandlerItemStack = new AirHandlerItemStack(new ItemStack((ItemLike)ModItems.REINFORCED_AIR_CANISTER.get())){

            public int getAir() {
                return ((IToolStackView)tool.get()).getPersistentData().getInt(LOCATION_AIR_STORAGE);
            }

            public void addAir(int amount) {
                if (((IToolStackView)tool.get()).getPersistentData().contains(LOCATION_AIR_STORAGE, 3)) {
                    ((IToolStackView)tool.get()).getPersistentData().putInt(LOCATION_AIR_STORAGE, ((IToolStackView)tool.get()).getPersistentData().getInt(LOCATION_AIR_STORAGE) + amount);
                } else {
                    ((IToolStackView)tool.get()).getPersistentData().putInt(LOCATION_AIR_STORAGE, amount);
                }
            }

            public int getBaseVolume() {
                return ((IToolStackView)tool.get()).getStats().getInt((IToolStat)EtSTLibToolStat.BASIC_AIR_CAPACITY);
            }

            public float getPressure() {
                return (float)this.getAir() / (float)this.getBaseVolume();
            }

            public void setBaseVolume(int newBaseVolume) {
            }

            public int getVolume() {
                return this.getBaseVolume();
            }

            public float maxPressure() {
                return ((Float)((IToolStackView)tool.get()).getStats().get((IToolStat)EtSTLibToolStat.MAX_PRESSURE)).floatValue();
            }
        };
        this.airHandlerItemLazyOptional = LazyOptional.of(() -> this.airHandlerItemStack);
    }

    public <T> LazyOptional<T> getCapability(IToolStackView iToolStackView, Capability<T> capability) {
        if (this.tool.get().getStats().getInt((IToolStat)EtSTLibToolStat.BASIC_AIR_CAPACITY) > 0) {
            return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.airHandlerItemLazyOptional);
        }
        return LazyOptional.empty();
    }

    public int getBaseVolume() {
        return this.tool.get().getStats().getInt((IToolStat)EtSTLibToolStat.BASIC_AIR_CAPACITY);
    }

    public int getVolumeUpgrades(ItemStack itemStack) {
        return 0;
    }

    public int getAir(ItemStack itemStack) {
        return this.tool.get().getPersistentData().getInt(LOCATION_AIR_STORAGE);
    }

    public float getMaxPressure() {
        return AirStorageProvider.getPressure(this.tool.get());
    }

    public int getEffectiveVolume(ItemStack stack) {
        return this.getBaseVolume();
    }

    public float getPressure(ItemStack stack) {
        return AirStorageProvider.getPressure(this.tool.get());
    }

    public static float getPressure(IToolStackView tool) {
        return (float)tool.getPersistentData().getInt(LOCATION_AIR_STORAGE) / (float)tool.getStats().getInt((IToolStat)EtSTLibToolStat.BASIC_AIR_CAPACITY);
    }

    public static int getAir(IToolStackView tool) {
        return tool.getPersistentData().getInt(LOCATION_AIR_STORAGE);
    }

    public static void addAir(IToolStackView tool, int amount) {
        if (tool.getPersistentData().contains(LOCATION_AIR_STORAGE, 3)) {
            tool.getPersistentData().putInt(LOCATION_AIR_STORAGE, tool.getPersistentData().getInt(LOCATION_AIR_STORAGE) + amount);
            if (tool.getPersistentData().getInt(LOCATION_AIR_STORAGE) < 0) {
                tool.getPersistentData().putInt(LOCATION_AIR_STORAGE, 0);
            }
        } else {
            tool.getPersistentData().putInt(LOCATION_AIR_STORAGE, amount);
        }
    }

    public static void setAir(IToolStackView tool, int amount) {
        tool.getPersistentData().putInt(LOCATION_AIR_STORAGE, amount);
    }

    public static int getBaseVolume(IToolStackView tool) {
        return tool.getStats().getInt((IToolStat)EtSTLibToolStat.BASIC_AIR_CAPACITY);
    }

    public static float getMaxPressure(IToolStackView tool) {
        return tool.getStats().getInt((IToolStat)EtSTLibToolStat.MAX_PRESSURE);
    }

    public static int getMaxVolume(IToolStackView tool) {
        return (int)((float)AirStorageProvider.getBaseVolume(tool) * AirStorageProvider.getMaxPressure(tool));
    }
}

