/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.client.renderer;

import com.c2h6s.tinkers_advanced.content.entity.MiningBeamProjectile;
import com.c2h6s.tinkers_advanced.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Random;

public class MiningBeamRenderer
extends EntityRenderer<MiningBeamProjectile> {
    public MiningBeamRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public boolean shouldRender(MiningBeamProjectile entity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        Vec3 vec3 = entity.m_20182_().m_82549_(entity.m_20184_().m_82490_((double)entity.getScale()));
        Vec3 vec32 = entity.m_20182_().m_82549_(entity.m_20184_().m_82490_((double)(entity.getScale() / 2.0f)));
        Vec3 cameraPos = new Vec3(pCamX, pCamY, pCamZ);
        return entity.m_20182_().m_82546_(cameraPos).m_82553_() < 64.0 || vec3.m_82546_(cameraPos).m_82553_() < 64.0 || vec32.m_82546_(cameraPos).m_82553_() < 64.0;
    }

    public void render(MiningBeamProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float distance = pEntity.getScale();
        if (distance > 1.0f) {
            boolean OffHand;
            Player player1;
            Player player;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = pEntity.m_19749_();
            Player player2 = player = entity instanceof Player ? (player1 = (Player)entity) : null;
            if (level == null || player == null) {
                return;
            }
            InteractionHand hand = player.m_7655_();
            Vec3 eyeOffset = player.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_((double)0.3f);
            boolean bl = OffHand = hand == InteractionHand.OFF_HAND;
            if (eyeOffset.m_82553_() == 0.0) {
                eyeOffset = new Vec3(0.3, 0.0, 0.0);
            }
            if (OffHand) {
                eyeOffset = eyeOffset.m_82548_();
            }
            double x = Mth.m_14139_((double)pPartialTick, (double)pEntity.f_19790_, (double)pEntity.m_20185_());
            double y = Mth.m_14139_((double)pPartialTick, (double)pEntity.f_19791_, (double)pEntity.m_20186_());
            double z = Mth.m_14139_((double)pPartialTick, (double)pEntity.f_19792_, (double)pEntity.m_20189_());
            boolean firstPerson = Minecraft.m_91087_().f_91063_.m_109153_().m_90592_() == player && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 finalpos = firstPerson ? Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82549_(eyeOffset) : player.m_146892_().m_82549_(eyeOffset);
            Vec3 offSet = finalpos.m_82492_(x, y, z);
            pPoseStack.m_85837_(offSet.f_82479_, offSet.f_82480_, offSet.f_82481_);
            BlockHitResult result = firstPerson ? level.m_45547_(new ClipContext(camera.m_90583_(), camera.m_90583_().m_82549_(new Vec3(camera.m_253058_().mul(pEntity.getScale()))), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)) : level.m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20154_().m_82541_().m_82490_((double)pEntity.getScale())), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            Vec3 vec3 = result.m_82450_().m_82546_(finalpos);
            distance = (float)vec3.m_82553_();
            double d0 = vec3.m_165924_();
            float yRot = (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875);
            float xRot = (float)(Mth.m_14136_((double)(-vec3.f_82480_), (double)d0) * 57.2957763671875);
            if (pEntity.getTick() < 2) {
                level.m_6801_(player.m_19879_(), result.m_82425_(), pEntity.getProgress());
            } else {
                level.m_6801_(player.m_19879_(), result.m_82425_(), -1);
            }
            if (!player.m_6117_()) {
                level.m_6801_(player.m_19879_(), result.m_82425_(), -1);
            }
            Random random = new Random();
            level.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(result.m_82425_())), false, (double)((float)result.m_82425_().m_123341_() + random.nextFloat()), (double)((float)result.m_82425_().m_123342_() + random.nextFloat()), (double)((float)result.m_82425_().m_123343_() + random.nextFloat()), 0.0, 0.0, 0.0);
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
            PoseStack.Pose pose = pPoseStack.m_85850_();
            Matrix4f poseMatrix = pose.m_252922_();
            Matrix3f normalMatrix = pose.m_252943_();
            float tick = Math.max(0.0f, (float)pEntity.getTick() + pPartialTick - 10.0f);
            float alphaPercent = Math.max(0.0f, (5.0f - tick) / 5.0f);
            VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110460_((ResourceLocation)this.getTextureLocation(pEntity), (boolean)false));
            RenderUtil.drawPipe(pPoseStack, consumer, poseMatrix, 0.01f * alphaPercent, distance, 255, 100, 80, 255, normalMatrix);
            consumer = pBuffer.m_6299_(RenderType.m_110460_((ResourceLocation)this.getTextureLocation(pEntity), (boolean)true));
            RenderUtil.drawPipe(pPoseStack, consumer, poseMatrix, 0.025f * alphaPercent, distance, 255, 0, 0, (int)(128.0f * alphaPercent), normalMatrix);
            pPoseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(MiningBeamProjectile projectile) {
        return new ResourceLocation("tinkers_advanced", "textures/entity/plasma_beam/white.png");
    }

    protected int getBlockLightLevel(MiningBeamProjectile pEntity, BlockPos pPos) {
        return 15;
    }

    protected int getSkyLightLevel(MiningBeamProjectile pEntity, BlockPos pPos) {
        return 15;
    }
}

