/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.block.blockEntity;

import com.c2h6s.tinkers_advanced.content.block.ExchangerBlock;
import com.c2h6s.tinkers_advanced.content.capability.ExchangerWrappedEnergyHandler;
import com.c2h6s.tinkers_advanced.content.item.toolItem.ElectronTunerItem;
import com.c2h6s.tinkers_advanced.content.modifier.generatorModifiers.PlayerLocating;
import com.c2h6s.tinkers_advanced.network.TiAcPacketHandler;
import com.c2h6s.tinkers_advanced.network.packets.PExchangerBEItemSyncS2C;
import com.c2h6s.tinkers_advanced.registery.TiAcBlockEntities;
import com.c2h6s.tinkers_advanced.registery.TiAcBlocks;
import com.c2h6s.tinkers_advanced.registery.TiAcItems;
import com.c2h6s.tinkers_advanced.util.CommonUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExchangerBlockEntity
extends BlockEntity {
    @NotNull
    public ItemStack exchangingItem = ItemStack.f_41583_;
    public boolean ensureSynced = false;

    public ExchangerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TiAcBlockEntities.EXCHANGER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && this.exchangingItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, direction).isPresent()) {
            return this.exchangingItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, direction).cast();
        }
        if (capability == ForgeCapabilities.ENERGY && this.exchangingItem.getCapability(ForgeCapabilities.ENERGY, direction).isPresent()) {
            return LazyOptional.of(() -> new ExchangerWrappedEnergyHandler(this)).cast();
        }
        if (this.exchangingItem.getCapability(capability, direction).isPresent()) {
            return this.exchangingItem.getCapability(capability, direction).cast();
        }
        if (CommonUtil.getCompactCapability(this.exchangingItem, capability, direction).isPresent()) {
            return CommonUtil.getCompactCapability(this.exchangingItem, capability, direction).cast();
        }
        return super.getCapability(capability, direction);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("exchanging_item", (Tag)this.exchangingItem.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.setExchangingItemServer(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("exchanging_item")));
        super.m_142466_(nbt);
    }

    public void setExchangingItemServer(ItemStack stack) {
        this.exchangingItem = stack;
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
            this.f_58857_.m_46672_(this.f_58858_, (Block)TiAcBlocks.EXCHANGER.get());
        }
        this.invalidateCaps();
        this.syncToClient(stack);
    }

    public void syncToClient(ItemStack stack) {
        TiAcPacketHandler.sendToClient(new PExchangerBEItemSyncS2C(stack, this.f_58858_));
    }

    public void dropItem() {
        if (this.f_58857_ instanceof ServerLevel && !this.exchangingItem.m_41619_()) {
            Vec3 pos = this.f_58858_.m_252807_();
            ItemEntity entity = new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.exchangingItem);
            this.f_58857_.m_7967_((Entity)entity);
            this.setExchangingItemServer(ItemStack.f_41583_);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ExchangerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.exchangingItem.m_41619_()) {
            return;
        }
        if (blockEntity.exchangingItem.m_150930_((Item)TiAcItems.ELECTRON_TUNER.get())) {
            ToolStack toolStack = ToolStack.from((ItemStack)blockEntity.exchangingItem);
            ToolDataNBT toolData = toolStack.getPersistentData();
            ServerPlayer holder = null;
            if (toolData.contains(PlayerLocating.KEY_PLAYER_ID, 8) && level.m_7654_() != null) {
                UUID uuid = null;
                try {
                    uuid = UUID.fromString(toolData.getString(PlayerLocating.KEY_PLAYER_ID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (uuid != null) {
                    holder = level.m_7654_().m_6846_().m_11259_(uuid);
                }
            }
            ElectronTunerItem.generatorTick(blockEntity.exchangingItem, level, holder, blockEntity);
        }
        if (state.m_60713_((Block)TiAcBlocks.EXCHANGER.get()) && ((Boolean)state.m_61143_((Property)ExchangerBlock.ENERGY_OUTPUT)).booleanValue()) {
            ExchangerBlockEntity.ejectEnergy(level, blockPos, state, blockEntity);
        }
    }

    public static void ejectEnergy(Level level, BlockPos blockPos, BlockState state, ExchangerBlockEntity blockEntity) {
        blockEntity.exchangingItem.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
            if (energyStorage.canExtract() && energyStorage.getEnergyStored() > 0) {
                for (Direction direction : Direction.values()) {
                    BlockPos relative = blockPos.m_121945_(direction);
                    BlockEntity neighbour = level.m_7702_(relative);
                    if (neighbour == null) continue;
                    neighbour.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(energyStorage1 -> {
                        int extract = energyStorage.extractEnergy(energyStorage.getEnergyStored(), true);
                        if ((extract = energyStorage1.receiveEnergy(extract, true)) > 0) {
                            energyStorage1.receiveEnergy(extract, false);
                            energyStorage.extractEnergy(extract, false);
                        }
                    });
                    if (energyStorage.getEnergyStored() > 0) continue;
                    return;
                }
            }
        });
    }
}

