/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.compact.pnc.capability;

import com.c2h6s.tinkers_advanced.content.compact.pnc.capability.IItemMachineConvertHandler;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMachineConvertHandler
implements IItemMachineConvertHandler,
ICapabilityProvider {
    public final ItemStack stack;
    private final IAirHandlerItem handlerItem;
    private final LazyOptional<IItemMachineConvertHandler> holder = LazyOptional.of(() -> this);

    public ItemMachineConvertHandler(ItemStack stack) {
        this.stack = stack;
        LazyOptional handlerItem = stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY);
        this.handlerItem = (IAirHandlerItem)handlerItem.orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY) {
            return this.holder.cast();
        }
        if (cap == PNCCapabilities.AIR_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }

    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }

    public float getPressure() {
        if (this.handlerItem != null) {
            return this.handlerItem.getPressure();
        }
        return 0.0f;
    }

    public int getAir() {
        if (this.handlerItem != null) {
            return this.handlerItem.getAir();
        }
        return 0;
    }

    public void addAir(int i) {
        if (this.handlerItem != null) {
            this.handlerItem.addAir(i);
        }
    }

    public int getBaseVolume() {
        if (this.handlerItem != null) {
            return this.handlerItem.getBaseVolume();
        }
        return 0;
    }

    public void setBaseVolume(int i) {
        if (this.handlerItem != null) {
            this.handlerItem.setBaseVolume(i);
        }
    }

    public int getVolume() {
        if (this.handlerItem != null) {
            return this.handlerItem.getVolume();
        }
        return 0;
    }

    public float maxPressure() {
        if (this.handlerItem != null) {
            return this.handlerItem.maxPressure();
        }
        return 0.0f;
    }

    public float getDangerPressure() {
        return 2.1474836E9f;
    }

    public float getCriticalPressure() {
        return 2.1474836E9f;
    }

    public void setPressure(float v) {
        if (this.handlerItem != null) {
            int newAir = (int)(v * (float)this.handlerItem.getVolume());
            this.handlerItem.addAir(newAir -= this.handlerItem.getAir());
        }
    }

    public void setVolumeUpgrades(int i) {
    }

    public void enableSafetyVenting(FloatPredicate floatPredicate, Direction direction) {
    }

    public void disableSafetyVenting() {
    }

    public void tick(BlockEntity blockEntity) {
    }

    public void setSideLeaking(@Nullable Direction direction) {
    }

    @Nullable
    public Direction getSideLeaking() {
        return null;
    }

    public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity blockEntity) {
        return List.of();
    }

    public void setConnectedFaces(List<Direction> list) {
    }

    public void printManometerMessage(Player player, List<Component> list) {
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

