/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.item.toolItem;

import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.content.capability.ElectronTunerItemCapabilityProvider;
import com.c2h6s.tinkers_advanced.content.entity.PlasmaSlashEntity;
import com.c2h6s.tinkers_advanced.content.item.tinkering.TiAcToolDefinitions;
import com.c2h6s.tinkers_advanced.content.menu.ElectronTunerMenu;
import com.c2h6s.tinkers_advanced.content.modifierHooks.GeneratorModuleModifierHook;
import com.c2h6s.tinkers_advanced.content.modifierHooks.ModifyGenerationModifierHook;
import com.c2h6s.tinkers_advanced.content.modifierHooks.TiAcModifierHooks;
import com.c2h6s.tinkers_advanced.content.objects.ToolEnergyProduction;
import com.c2h6s.tinkers_advanced.network.TiAcPacketHandler;
import com.c2h6s.tinkers_advanced.network.packets.PElectronTunerMenuSyncS2C;
import com.c2h6s.tinkers_advanced.network.packets.PElectronTunerOpenMenuC2S;
import com.c2h6s.tinkers_advanced.registery.TiAcItems;
import com.c2h6s.tinkers_advanced.registery.TiAcToolStats;
import com.c2h6s.tinkers_advanced.util.CommonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolEnergyCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;

@Mod.EventBusSubscriber(modid="tinkers_advanced", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElectronTunerItem
extends ModifiableSwordItem {
    public static final ResourceLocation KEY_ATTACK_DAMAGE = TinkersAdvanced.getLocation("attack_damage_factor");
    public static final ResourceLocation KEY_DISALLOW_INSERT = TinkersAdvanced.getLocation("disallow_insert");
    public static final MutableComponent itemName = Component.m_237115_((String)("item." + TiAcItems.ELECTRON_TUNER.getId().m_214298_()));

    public ElectronTunerItem(Item.Properties properties) {
        super(properties, TiAcToolDefinitions.ELECTRON_TUNER);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        if (playerIn.m_6144_()) {
            playerIn.m_6672_(hand);
            int slot = playerIn.m_150109_().m_36030_(playerIn.m_21120_(hand));
            if (playerIn.m_9236_().f_46443_) {
                TiAcPacketHandler.sendToServer(new PElectronTunerOpenMenuC2S(slot));
            }
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(hand));
        }
        return super.m_7203_(worldIn, playerIn, hand);
    }

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    public static void generatorTick(ItemStack stack, Level level, @Nullable LivingEntity holderEntity, @Nullable BlockEntity holderBlockEntity) {
        if (!CommonUtil.isModifiable(stack)) {
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ToolEnergyProduction production = tool.getPersistentData().contains(ToolEnergyProduction.LOCATION, 10) ? ToolEnergyProduction.readFromTool(tool) : ToolEnergyProduction.getOrCreate(tool);
        if (production.needUpdate()) {
            long remainedEnergyToGen = production.energyToProduce;
            long remainedEnergyToCost = production.energyToReduce;
            long energyToGenTotal = 0L;
            long energyToCostTotal = 0L;
            int energyToGenerateThisTick = production.generatePerTick;
            int energyToConsumeThisTick = production.consumePerTick;
            if (production.requireGeneration()) {
                energyToGenerateThisTick = 0;
            }
            if (production.requireConsumption()) {
                energyToConsumeThisTick = 0;
            }
            IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            for (ModifierEntry modifier : tool.getModifierList()) {
                Iterator hook = (GeneratorModuleModifierHook)modifier.getHook(TiAcModifierHooks.GENERATOR_MODULE);
                int baseAmount = hook.getBasicGeneration((IToolStackView)tool, modifier);
                int amplifiedAmount = (int)((float)baseAmount * ((Float)tool.getStats().get((IToolStat)TiAcToolStats.POWER_MULTIPLIER)).floatValue());
                if ((amplifiedAmount = hook.getConditionalGeneration((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, baseAmount, amplifiedAmount)) > 0 && production.requireGeneration() && (energyToGenTotal += hook.shrinkIngredientAndGetTotalEnergy((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, amplifiedAmount, handler)) > 0L) {
                    energyToGenerateThisTick += amplifiedAmount;
                }
                if (amplifiedAmount >= 0 || !production.requireConsumption()) continue;
                energyToCostTotal -= hook.shrinkIngredientAndGetTotalEnergy((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, amplifiedAmount, handler);
                if (energyToGenTotal <= 0L) continue;
                energyToConsumeThisTick -= amplifiedAmount;
            }
            energyToGenTotal = Math.max(energyToGenTotal, 0L);
            energyToCostTotal = Math.max(energyToCostTotal, 0L);
            if (energyToGenTotal > 0L) {
                long baseAmount = energyToGenTotal;
                for (ModifierEntry modifier : tool.getModifierList()) {
                    energyToGenTotal = ((ModifyGenerationModifierHook)modifier.getHook(TiAcModifierHooks.MODIFY_GENERATION)).modifyTotalGeneration((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, stack, baseAmount, energyToGenTotal);
                }
            }
            if (energyToCostTotal > 0L) {
                long baseAmount = energyToCostTotal;
                for (ModifierEntry modifier : tool.getModifierList()) {
                    energyToCostTotal = -((ModifyGenerationModifierHook)modifier.getHook(TiAcModifierHooks.MODIFY_GENERATION)).modifyTotalGeneration((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, stack, -baseAmount, -energyToCostTotal);
                }
            }
            energyToGenTotal = Math.max(energyToGenTotal, 0L);
            energyToCostTotal = Math.max(energyToCostTotal, 0L);
            energyToConsumeThisTick = Math.max(energyToConsumeThisTick, 0);
            energyToGenerateThisTick = Math.max(energyToGenerateThisTick, 0);
            production.energyToProduce = remainedEnergyToGen += energyToGenTotal;
            production.energyToReduce = remainedEnergyToCost += energyToCostTotal;
            if (energyToGenerateThisTick > 0 && remainedEnergyToGen > 0L) {
                int baseAmount = energyToGenerateThisTick;
                for (ModifierEntry modifier : tool.getModifierList()) {
                    energyToGenerateThisTick = ((ModifyGenerationModifierHook)modifier.getHook(TiAcModifierHooks.MODIFY_GENERATION)).modifyTotalPerTick((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, stack, baseAmount, energyToGenerateThisTick);
                }
                energyToGenerateThisTick = Math.max(energyToGenerateThisTick, 0);
            }
            if (energyToConsumeThisTick > 0 && remainedEnergyToCost > 0L) {
                int baseAmount = energyToConsumeThisTick;
                for (ModifierEntry modifier : tool.getModifierList()) {
                    energyToConsumeThisTick = -((ModifyGenerationModifierHook)modifier.getHook(TiAcModifierHooks.MODIFY_GENERATION)).modifyTotalPerTick((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, stack, baseAmount, -energyToConsumeThisTick);
                }
                energyToConsumeThisTick = Math.max(energyToConsumeThisTick, 0);
            }
            production.consumePerTick = energyToConsumeThisTick;
            production.generatePerTick = energyToGenerateThisTick;
        }
        production.toolStack = tool;
        production.tick();
        if (level.m_7654_() != null) {
            production.gameTimeLastTick = level.m_7654_().m_129921_();
        }
        int changed = production.lastGeneration;
        ToolEnergyProduction.updateProduction(tool, production);
        for (ModifierEntry modifier : tool.getModifierList()) {
            ((ModifyGenerationModifierHook)modifier.getHook(TiAcModifierHooks.MODIFY_GENERATION)).onGeneratorTick((IToolStackView)tool, modifier, holderEntity, holderBlockEntity, stack, changed);
        }
        if (holderEntity instanceof Player) {
            ElectronTunerMenu menu;
            Player player = (Player)holderEntity;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof ElectronTunerMenu && (menu = (ElectronTunerMenu)abstractContainerMenu).getToolItem() == stack) {
                menu.updateToolSlot(stack);
                TiAcPacketHandler.sendToClient(new PElectronTunerMenuSyncS2C(stack, menu.toolSlot));
            }
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_) {
            LivingEntity e;
            LivingEntity holder = entityIn instanceof LivingEntity ? (e = (LivingEntity)entityIn) : null;
            ElectronTunerItem.generatorTick(stack, worldIn, holder, null);
        }
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (slot.m_150651_(player) && action == ClickAction.SECONDARY && held.m_41619_() && CommonUtil.isModifiable(slotStack)) {
            ToolStack tool = ToolStack.from((ItemStack)slotStack);
            tool.getPersistentData().putBoolean(KEY_DISALLOW_INSERT, !tool.getPersistentData().getBoolean(KEY_DISALLOW_INSERT));
            return true;
        }
        return super.m_142305_(slotStack, held, slot, action, player, access);
    }

    public static float getSlashScale(IToolStackView tool) {
        return ((float)tool.getModifierLevel(TinkerModifiers.expanded.get()) + 1.5f) * (0.5f * (float)ElectronTunerItem.getMode(tool) + 0.5f);
    }

    public static float getSlashDamage(IToolStackView tool) {
        float bonus = Math.min(0.6f, 0.2f * (float)tool.getModifierLevel(TinkerModifiers.sweeping.get()));
        return (((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() + 1.0f) * (0.2f + bonus);
    }

    public static float getSlashDamageBonus(IToolStackView tool) {
        float bonus = Math.min(0.6f, 0.2f * (float)tool.getModifierLevel(TinkerModifiers.sweeping.get()));
        bonus = Math.min(bonus, (float)ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((int)((float)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get() * 4) * bonus)), (boolean)true) / ((float)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()).intValue() * 4.0f));
        return bonus;
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        Level level;
        if (CommonUtil.isModifiable(stack) && ((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue() && (double)player.m_36403_(0.0f) > 0.8 && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ToolStack tool = ToolStack.from((ItemStack)stack);
            if (ElectronTunerItem.getMode((IToolStackView)tool) >= 1 && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)true) >= (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()) {
                float bonus = ElectronTunerItem.getSlashDamageBonus((IToolStackView)tool);
                ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((int)((float)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get() * 4) * bonus)), (boolean)false);
                PlasmaSlashEntity entity = PlasmaSlashEntity.create((LivingEntity)player, ElectronTunerItem.getSlashScale((IToolStackView)tool), player.m_20154_(), tool);
                entity.baseDamage = ElectronTunerItem.getSlashDamage((IToolStackView)tool);
                level2.m_7967_((Entity)entity);
            }
        }
        return super.onLeftClickEntity(stack, player, target);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level;
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(player.m_7655_());
        if (CommonUtil.isModifiable(stack) && ((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue() && (double)player.m_36403_(0.0f) > 0.8 && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ToolStack tool = ToolStack.from((ItemStack)stack);
            if (ElectronTunerItem.getMode((IToolStackView)tool) == 1 && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)true) >= (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()) {
                float bonus = ElectronTunerItem.getSlashDamageBonus((IToolStackView)tool);
                ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((int)((float)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get() * 4) * bonus)), (boolean)false);
                PlasmaSlashEntity entity = PlasmaSlashEntity.create((LivingEntity)player, ElectronTunerItem.getSlashScale((IToolStackView)tool), player.m_20154_(), tool);
                entity.baseDamage = ElectronTunerItem.getSlashDamage((IToolStackView)tool);
                level2.m_7967_((Entity)entity);
            }
        }
    }

    public static List<Component> getInfoList(IToolStackView tool) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)ToolStats.ATTACK_DAMAGE.getTranslationKey()).m_130946_(String.format("%.2f", Float.valueOf(((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() + 1.0f))).m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)ToolStats.ATTACK_SPEED.getTranslationKey()).m_130946_(String.format("%.2f", tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED))).m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)ElectronTunerItem.getModeKey(tool)).m_130940_(ChatFormatting.GOLD)));
        if (((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue()) {
            list.add(Component.m_237115_((String)(ElectronTunerItem.getModeKey(tool) + ".bonus")).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        return list;
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null) {
            tooltips.add((Component)Component.m_237115_((String)"tool_stat.tinkers_advanced.generate_factor").m_130946_("\u00a74" + tool.getStats().get((IToolStat)TiAcToolStats.POWER_MULTIPLIER)));
        }
        return super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        if (stack.m_41720_() instanceof ElectronTunerItem) {
            return new ToolCapabilityProvider(stack){

                @NotNull
                public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                    if (cap == ForgeCapabilities.ITEM_HANDLER) {
                        return LazyOptional.of(() -> new ElectronTunerItemCapabilityProvider(() -> ToolStack.from((ItemStack)stack), side == null)).cast();
                    }
                    return super.getCapability(cap, side);
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }

    public static int getMode(IToolStackView tool) {
        if (ToolEnergyCapability.getEnergy((IToolStackView)tool) <= 0) {
            return -1;
        }
        if ((double)tool.getPersistentData().getFloat(KEY_ATTACK_DAMAGE) < 0.25) {
            return 0;
        }
        if ((double)tool.getPersistentData().getFloat(KEY_ATTACK_DAMAGE) < 0.75) {
            return 1;
        }
        return 2;
    }

    public static String getModeKey(IToolStackView tool) {
        if ((double)tool.getPersistentData().getFloat(KEY_ATTACK_DAMAGE) < 0.25) {
            return "info.tinkers_advanced.electron_tuner.rapier";
        }
        if ((double)tool.getPersistentData().getFloat(KEY_ATTACK_DAMAGE) < 0.75) {
            return "info.tinkers_advanced.electron_tuner.sword";
        }
        return "info.tinkers_advanced.electron_tuner.cleaver";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ToolStack tool = ToolStack.from((ItemStack)stack);
        tooltip.add((Component)Component.m_237115_((String)(tool.getPersistentData().getBoolean(KEY_DISALLOW_INSERT) ? "tooltip.tinkers_advanced.disallow_insert" : "tooltip.tinkers_advanced.allow_insert")).m_130940_(ChatFormatting.RED));
    }
}

