/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.item.toolItem;

import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.content.entity.MiningBeamProjectile;
import com.c2h6s.tinkers_advanced.content.item.tinkering.TiAcToolDefinitions;
import com.c2h6s.tinkers_advanced.registery.TiAcToolStats;
import com.c2h6s.tinkers_advanced.util.HarvestLogic;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.fluid.block.BreakBlockFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.general.ConditionalFluidEffect;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningTierToolHook;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;

public class MatterManipulator
extends ModifiableItem {
    public static final ResourceLocation LOCATION_MINING = TinkersAdvanced.getLocation("mining_boolean");
    public static final ResourceLocation LOCATION_SEC_MODE = TinkersAdvanced.getLocation("mining_mode_secondary");
    public static final ResourceLocation LOCATION_PRI_MODE = TinkersAdvanced.getLocation("mining_mode_primary");
    public static final ResourceLocation LOCATION_ENTITY_ID = TinkersAdvanced.getLocation("mining_laser_id");
    public static final String KEY_BLOCK_POSX = "tiac_bp_legacyx";
    public static final String KEY_BLOCK_POSY = "tiac_bp_legacyy";
    public static final String KEY_BLOCK_POSZ = "tiac_bp_legacyz";
    public static final String KEY_DESTORY = "tiac_bp_legacy";

    public MatterManipulator(Item.Properties properties) {
        super(properties, TiAcToolDefinitions.MATTER_MANIPULATOR);
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        return super.m_142207_(held, slot, action, player);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        return tool.getPersistentData().getBoolean(LOCATION_MINING);
    }

    public boolean m_8096_(BlockState pBlock) {
        return true;
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (slot.m_150651_(player) && action == ClickAction.SECONDARY) {
            ToolStack tool = ToolStack.from((ItemStack)slotStack);
            if (held.m_41619_()) {
                tool.getPersistentData().putBoolean(LOCATION_SEC_MODE, !tool.getPersistentData().getBoolean(LOCATION_SEC_MODE));
            }
            if (held.m_150930_(TinkerToolParts.toolHandle.m_5456_())) {
                tool.getPersistentData().putBoolean(LOCATION_PRI_MODE, !tool.getPersistentData().getBoolean(LOCATION_PRI_MODE));
            }
            super.m_142305_(slotStack, held, slot, action, player, access);
            return true;
        }
        return super.m_142305_(slotStack, held, slot, action, player, access);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return BlockingModifier.blockWhileCharging((IToolStackView)ToolStack.from((ItemStack)stack), (UseAnim)UseAnim.BOW);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        boolean creative = player.m_150110_().f_35937_;
        ItemStack stack = player.m_21120_(hand);
        ToolStack tool = ToolStack.from((ItemStack)stack);
        FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        if (fluidStack.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        tool.getPersistentData().putBoolean(LOCATION_MINING, true);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        tool.getPersistentData().putBoolean(LOCATION_MINING, false);
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int timeLeft) {
        if (living instanceof Player) {
            BlockHitResult result;
            MiningBeamProjectile e;
            MiningBeamProjectile projectile;
            Player player = (Player)living;
            ToolStack tool = ToolStack.from((ItemStack)stack);
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
            if (fluidStack.isEmpty()) {
                living.m_5810_();
                return;
            }
            float baseRange = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.RANGE);
            baseRange += (float)(player.getEntityReach() * 2.0);
            Entity entity = level.m_6815_(tool.getPersistentData().getInt(LOCATION_ENTITY_ID));
            MiningBeamProjectile miningBeamProjectile = projectile = entity instanceof MiningBeamProjectile ? (e = (MiningBeamProjectile)entity) : null;
            if (projectile == null) {
                boolean OffHand;
                MiningBeamProjectile projectile1 = new MiningBeamProjectile(level, baseRange);
                projectile1.m_146884_(player.m_146892_());
                projectile1.stack = stack;
                Vec3 offset = player.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_((double)0.3f);
                boolean bl = OffHand = player.m_7655_() == InteractionHand.OFF_HAND;
                if (OffHand) {
                    offset = offset.m_82548_();
                }
                projectile1.m_146884_(player.m_146892_().m_82549_(offset));
                projectile1.m_5602_((Entity)player);
                level.m_7967_((Entity)projectile1);
                tool.getPersistentData().putInt(LOCATION_ENTITY_ID, projectile1.m_19879_());
                projectile = projectile1;
            }
            if ((result = level.m_45547_(new ClipContext(living.m_146892_(), living.m_146892_().m_82549_(living.m_20154_().m_82541_().m_82490_((double)baseRange)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() != HitResult.Type.MISS && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    UseOnContext context = new UseOnContext(level, player, player.m_7655_(), stack, result);
                    BlockPos blockPos = result.m_82425_();
                    BlockState blockState = level.m_8055_(blockPos);
                    boolean isEffective = IsEffectiveToolHook.isEffective((IToolStackView)tool, (BlockState)blockState);
                    Random random = new Random();
                    float fluidEfficiency = ((Float)tool.getStats().get((IToolStat)TiAcToolStats.FLUID_EFFICIENCY)).floatValue();
                    fluidEfficiency = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.FLUID_EFFICIENCY, (float)fluidEfficiency);
                    float fluidFactor = Math.max(0.0f, 1.0f - fluidEfficiency);
                    Tier tier = MiningTierToolHook.getTier((IToolStackView)tool);
                    if ((isEffective || !blockState.m_60834_() && blockState.m_60800_((BlockGetter)level, blockPos) >= 0.0f) && !tool.getPersistentData().getBoolean(LOCATION_PRI_MODE)) {
                        if (random.nextFloat() < fluidFactor && !player.m_150110_().f_35937_) {
                            fluidStack.shrink(1);
                            ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, new FluidStack(fluidStack.getFluid(), fluidStack.getAmount()));
                        }
                        BlockPos legacy = new BlockPos(player.getPersistentData().m_128451_(KEY_BLOCK_POSX), player.getPersistentData().m_128451_(KEY_BLOCK_POSY), player.getPersistentData().m_128451_(KEY_BLOCK_POSZ));
                        if (!result.m_82425_().equals((Object)legacy)) {
                            player.getPersistentData().m_128405_(KEY_DESTORY, 0);
                        }
                        player.getPersistentData().m_128405_(KEY_BLOCK_POSX, result.m_82425_().m_123341_());
                        player.getPersistentData().m_128405_(KEY_BLOCK_POSY, result.m_82425_().m_123342_());
                        player.getPersistentData().m_128405_(KEY_BLOCK_POSZ, result.m_82425_().m_123343_());
                        float destroySpeed = level.m_8055_(blockPos).m_60800_((BlockGetter)level, blockPos) * 10.0f;
                        float destroyProgress = player.getPersistentData().m_128457_(KEY_DESTORY);
                        float breakSpeed = (float)((double)ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)ToolStats.MINING_SPEED) * player.m_21133_(Attributes.f_22283_) * (Double)TiAcConfig.COMMON.MATTER_MANIPULATOR_BASE_BOOST.get());
                        breakSpeed += (float)((double)((float)fluidStack.getFluid().getFluidType().getTemperature() / 100.0f) * (Double)TiAcConfig.COMMON.MATTER_MANIPULATOR_FLUID_BOOST.get());
                        FluidEffects fluidEffects = FluidEffectManager.INSTANCE.find(fluidStack.getFluid());
                        ItemStack stack1 = stack.m_41777_();
                        Map map = stack1.getAllEnchantments();
                        if (fluidEffects.hasBlockEffects()) {
                            for (FluidEffect effect : fluidEffects.blockEffects()) {
                                ConditionalFluidEffect effect1;
                                if (effect instanceof ConditionalFluidEffect) {
                                    effect1 = (ConditionalFluidEffect)effect;
                                    effect = effect1.effect();
                                }
                                if (!(effect instanceof BreakBlockFluidEffect)) continue;
                                effect1 = (BreakBlockFluidEffect)effect;
                                breakSpeed += (float)((double)(effect1.hardness() / 10.0f) * (Double)TiAcConfig.COMMON.MATTER_MANIPULATOR_FLUID_BOOST.get());
                                if (!((Boolean)TiAcConfig.COMMON.MATTER_MANIPULATOR_FLUID_ENCHANTING.get()).booleanValue() || effect1.enchantments().isEmpty()) continue;
                                effect1.enchantments().forEach((enchantment, integer) -> map.merge(enchantment, integer, Integer::sum));
                                EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack1);
                            }
                        }
                        if (TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) {
                            ToolStack copy = ToolStack.from((ItemStack)stack1);
                            breakSpeed = ForgeEventFactory.getBreakSpeed((Player)player, (BlockState)blockState, (float)breakSpeed, (BlockPos)blockPos);
                            if (tool.getPersistentData().getBoolean(LOCATION_SEC_MODE)) {
                                breakSpeed = (float)((double)breakSpeed * (Double)TiAcConfig.COMMON.MATTER_MANIPULATOR_AOE_SPEED.get());
                            }
                            destroyProgress += Mth.m_14036_((float)(breakSpeed / destroySpeed), (float)0.0f, (float)(10.0f - destroyProgress));
                            level.m_6801_(player.m_19879_(), blockPos, (int)destroyProgress);
                            if (destroyProgress >= 10.0f) {
                                HarvestLogic.breakBlockAndGiveItem(copy, stack1, new ToolHarvestContext(serverLevel, serverPlayer, blockState, blockPos, result.m_82434_(), blockState.canHarvestBlock((BlockGetter)level, blockPos, (Player)serverPlayer), this.m_8096_(blockState)));
                                for (ModifierEntry entry : tool.getModifierList()) {
                                    ((ToolDamageModifierHook)entry.getHook(ModifierHooks.TOOL_DAMAGE)).onDamageTool((IToolStackView)tool, entry, 1, (LivingEntity)player);
                                }
                                serverLevel.m_5594_(null, blockPos, blockState.getSoundType((LevelReader)level, blockPos, null).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                if (tool.getPersistentData().getBoolean(LOCATION_SEC_MODE)) {
                                    for (BlockPos blockPos1 : ((AreaOfEffectIterator)tool.getHook(ToolHooks.AOE_ITERATOR)).getBlocks((IToolStackView)tool, context, blockState, AreaOfEffectIterator.AOEMatchType.DISPLAY)) {
                                        BlockState blockState1 = level.m_8055_(blockPos1);
                                        float destroySpeed1 = blockState1.m_60800_((BlockGetter)level, blockPos1);
                                        if (!IsEffectiveToolHook.isEffective((IToolStackView)tool, (BlockState)blockState1) && (blockState.m_60834_() || !(blockState.m_60800_((BlockGetter)level, blockPos) >= 0.0f)) || !((double)destroySpeed1 <= (double)destroySpeed + 0.5) || !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState1) || !HarvestLogic.breakBlockAndGiveItem(copy, stack1, new ToolHarvestContext(serverLevel, serverPlayer, blockState1, blockPos1, result.m_82434_(), blockState1.canHarvestBlock((BlockGetter)level, blockPos1, (Player)serverPlayer), this.m_8096_(blockState1)))) continue;
                                        if (random.nextFloat() < fluidFactor * 0.25f && !player.m_150110_().f_35937_) {
                                            fluidStack.shrink(1);
                                            ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, new FluidStack(fluidStack.getFluid(), fluidStack.getAmount()));
                                        }
                                        for (ModifierEntry entry : tool.getModifierList()) {
                                            ((ToolDamageModifierHook)entry.getHook(ModifierHooks.TOOL_DAMAGE)).onDamageTool((IToolStackView)tool, entry, 1, (LivingEntity)player);
                                        }
                                    }
                                }
                                player.getPersistentData().m_128405_(KEY_DESTORY, 0);
                                destroyProgress = 0.0f;
                            } else {
                                player.getPersistentData().m_128350_(KEY_DESTORY, destroyProgress);
                            }
                            projectile.setProgress((int)destroyProgress);
                        }
                    } else if (tool.getPersistentData().getBoolean(LOCATION_PRI_MODE)) {
                        FluidEffects fluidEffects = FluidEffectManager.INSTANCE.find(fluidStack.getFluid());
                        if (fluidEffects.hasBlockEffects()) {
                            FluidEffectContext.Block context1 = FluidEffectContext.builder((Level)level).user(player).block(result);
                            if (fluidEffects.applyToBlock(new FluidStack(fluidStack.getFluid(), 1000), 2.0f, context1, IFluidHandler.FluidAction.SIMULATE) > 0) {
                                fluidStack.shrink(fluidEffects.applyToBlock(new FluidStack(fluidStack.getFluid(), 1000), 2.0f, context1, IFluidHandler.FluidAction.EXECUTE));
                            }
                            if (tool.getPersistentData().getBoolean(LOCATION_SEC_MODE)) {
                                for (BlockPos blockPos1 : ((AreaOfEffectIterator)tool.getHook(ToolHooks.AOE_ITERATOR)).getBlocks((IToolStackView)tool, context, blockState, AreaOfEffectIterator.AOEMatchType.DISPLAY)) {
                                    BlockHitResult result1 = new BlockHitResult(blockPos1.m_252807_(), result.m_82434_(), blockPos1, true);
                                    FluidEffectContext.Block context2 = FluidEffectContext.builder((Level)level).user(player).block(result1);
                                    if (fluidEffects.applyToBlock(new FluidStack(fluidStack.getFluid(), 1000), 2.0f, context2, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                                    fluidStack.shrink(fluidEffects.applyToBlock(new FluidStack(fluidStack.getFluid(), 1000), 2.0f, context2, IFluidHandler.FluidAction.EXECUTE));
                                }
                            }
                        }
                        if (!player.m_150110_().f_35937_) {
                            ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, fluidStack);
                        }
                    }
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        super.m_5551_(stack, worldIn, entityLiving, timeLeft);
        entityLiving.getPersistentData().m_128405_(KEY_DESTORY, 0);
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null) {
            float fluidEfficiency = ((Float)tool.getStats().get((IToolStat)TiAcToolStats.FLUID_EFFICIENCY)).floatValue();
            fluidEfficiency = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.FLUID_EFFICIENCY, (float)fluidEfficiency);
            float baseRange = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.RANGE);
            float fluidFactor = Math.max(0.0f, 1.0f - fluidEfficiency);
            tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.fluid_consumption").m_130946_(" : \u00a74" + String.format("%.1f", Float.valueOf(100.0f * fluidFactor)) + "% * 1mB"));
            tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.range").m_130946_(" : \u00a7e" + (baseRange += (float)(player.getEntityReach() * 2.0))));
        }
        super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
        return tooltips;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ToolStack tool = ToolStack.from((ItemStack)stack);
        tooltip.add((Component)Component.m_237115_((String)(tool.getPersistentData().getBoolean(LOCATION_PRI_MODE) ? "tooltip.tinkers_advanced.splashing_mode" : "tooltip.tinkers_advanced.mining_mode")).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.primary_mode_info").m_130940_(ChatFormatting.DARK_AQUA));
        int expandw = 3 + 2 * ((tool.getModifierLevel(TinkerModifiers.expanded.getId()) + 1) / 2);
        int expandh = 3 + 2 * (tool.getModifierLevel(TinkerModifiers.expanded.getId()) / 2);
        tooltip.add((Component)Component.m_237115_((String)(tool.getPersistentData().getBoolean(LOCATION_SEC_MODE) ? "tooltip.tinkers_advanced.expand_mining" : "tooltip.tinkers_advanced.single_mining")).m_130946_((String)(tool.getPersistentData().getBoolean(LOCATION_SEC_MODE) ? expandw + " * " + expandh : "")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.BOLD));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.secondary_mode_info").m_130940_(ChatFormatting.DARK_PURPLE));
    }
}

