/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.combat;

import com.c2h6s.etstlib.content.misc.entityTicker.EntityTicker;
import com.c2h6s.etstlib.content.misc.entityTicker.EntityTickerInstance;
import com.c2h6s.etstlib.content.misc.entityTicker.EntityTickerManager;
import com.c2h6s.etstlib.content.misc.vibration.VibrationContext;
import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.VibrationListeningModifierHook;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.registery.TiAcEntityTicker;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class EchoLocating
extends EtSTBaseModifier
implements VibrationListeningModifierHook {
    public static final UUID ECHO_UUID = UUID.fromString("f9e0ced7-997a-cc95-3947-9106ecea3b3a");
    public static final ResourceLocation KEY_COOLDOWN = TinkersAdvanced.getLocation("echo_locating_cooldown");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.EQUIPMENT_CHANGE, EtSTLibHooks.VIBRATION_LISTENING);
    }

    public UUID getAcceptorUUID(IToolStackView iToolStackView, ModifierEntry modifierEntry, Player player, Level level, EquipmentSlot equipmentSlot) {
        return ECHO_UUID;
    }

    public int listenRange(IToolStackView iToolStackView, ModifierEntry modifierEntry, Player player, Level level, EquipmentSlot equipmentSlot, int i) {
        return 16;
    }

    public boolean canReceiveVibration(IToolStackView iToolStackView, ModifierEntry modifierEntry, Player player, ServerLevel serverLevel, EquipmentSlot equipmentSlot, VibrationContext vibrationContext) {
        Entity instance;
        if (iToolStackView.getPersistentData().getInt(KEY_COOLDOWN) > 0) {
            return false;
        }
        Entity entity = vibrationContext.directEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            instance = EntityTickerManager.getInstance((Entity)living);
            return !instance.hasTicker((EntityTicker)TiAcEntityTicker.SCULK_MARKED.get()) && living != player;
        }
        instance = vibrationContext.projectileOwner;
        if (instance instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)instance;
            return !(instance = EntityTickerManager.getInstance((Entity)living)).hasTicker((EntityTicker)TiAcEntityTicker.SCULK_MARKED.get()) && living != player;
        }
        return false;
    }

    public void onReceivingVibration(IToolStackView iToolStackView, ModifierEntry modifierEntry, Player player, ServerLevel serverLevel, EquipmentSlot equipmentSlot, VibrationContext vibrationContext) {
        LivingEntity entity;
        LivingEntity living = null;
        Entity entity2 = vibrationContext.projectileOwner;
        if (entity2 instanceof LivingEntity) {
            living = entity = (LivingEntity)entity2;
        }
        if ((entity2 = vibrationContext.directEntity) instanceof LivingEntity) {
            living = entity = (LivingEntity)entity2;
        }
        if (living != null) {
            EntityTickerManager.EntityTickerManagerInstance managerInstance = EntityTickerManager.getInstance((Entity)living);
            managerInstance.addTicker(new EntityTickerInstance((EntityTicker)TiAcEntityTicker.SCULK_MARKED.get(), 1, 10 + 10 * modifierEntry.getLevel()), Integer::max, Integer::sum);
            iToolStackView.getPersistentData().putInt(KEY_COOLDOWN, 4);
        }
    }

    public void postMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Entity entity = context.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = context.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                EntityTickerManager.EntityTickerManagerInstance instance = EntityTickerManager.getInstance((Entity)living);
                if (instance.hasTicker((EntityTicker)TiAcEntityTicker.SCULK_MARKED.get())) {
                    living.m_6469_((DamageSource)LegacyDamageSource.any((DamageSource)living.m_269291_().m_269285_((Entity)context.getAttacker())).setBypassInvulnerableTime(), damageDealt * 0.5f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void afterArrowHit(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull LivingEntity target, float damageDealt) {
        Level level;
        if (attacker != null && (level = attacker.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityTickerManager.EntityTickerManagerInstance instance = EntityTickerManager.getInstance((Entity)target);
            if (instance.hasTicker((EntityTicker)TiAcEntityTicker.SCULK_MARKED.get())) {
                target.m_6469_((DamageSource)LegacyDamageSource.any((DamageSource)attacker.m_269291_().m_269285_((Entity)attacker)).setBypassInvulnerableTime(), damageDealt * 0.5f);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, target.m_20185_(), target.m_20186_() + 0.5 * (double)target.m_20206_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && world.m_46467_() % 5L == 0L && tool.getPersistentData().getInt(KEY_COOLDOWN) > 0) {
            tool.getPersistentData().putInt(KEY_COOLDOWN, tool.getPersistentData().getInt(KEY_COOLDOWN) - 1);
        }
    }
}

