/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.combat.toolBase;

import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.etstlib.tool.modifiers.base.BasicFEModifier;
import com.c2h6s.etstlib.util.IToolUuidGetter;
import com.c2h6s.etstlib.util.MathUtil;
import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.entity.PlasmaSlashEntity;
import com.c2h6s.tinkers_advanced.content.item.toolItem.ElectronTunerItem;
import com.c2h6s.tinkers_advanced.content.objects.ToolEnergyProduction;
import com.c2h6s.tinkers_advanced.util.CommonUtil;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class EnderTuning
extends BasicFEModifier
implements ModifierTraitHook,
AttributesModifierHook,
ToolDamageModifierHook,
TooltipModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_STATS, ModifierHooks.MODIFIER_TRAITS, ModifierHooks.ATTRIBUTES, ModifierHooks.TOOL_DAMAGE, ModifierHooks.TOOLTIP});
    }

    public boolean isNoLevels() {
        return true;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void onLeftClickEmpty(IToolStackView tool, ModifierEntry entry, Player player, Level level, EquipmentSlot equipmentSlot) {
        if (!level.f_46443_ && ((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue() && ElectronTunerItem.getMode(tool) == 1 && (double)player.m_36403_(0.0f) > 0.8 && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)true) >= (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()) {
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)((Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)false);
            PlasmaSlashEntity entity = PlasmaSlashEntity.create((LivingEntity)player, ElectronTunerItem.getSlashScale(tool), player.m_20154_(), (ToolStack)tool);
            entity.baseDamage = ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * (0.25f + Math.min(0.75f, 0.25f * (float)tool.getModifierLevel(TinkerModifiers.sweeping.get())));
            level.m_7967_((Entity)entity);
        }
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        int energyCost = ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(amount * (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)true);
        if (energyCost >= (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()) {
            int cancel = energyCost / (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get();
            amount -= cancel;
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(cancel * (Integer)TiAcConfig.COMMON.ELECTRON_TUNER_CONSUMPTION.get()), (boolean)false);
        }
        return amount;
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        super.addToolStats(iToolContext, modifierEntry, modifierStatsBuilder);
        float value = iToolContext.getPersistentData().getFloat(ElectronTunerItem.KEY_ATTACK_DAMAGE);
        if ((double)value - 0.5 != 0.0) {
            float damageModifier = (float)Math.abs((Double)TiAcConfig.COMMON.ELECTRON_TUNER_ATTACK_DAMAGE_ADJUSTABLE_RANGE.get() * ((double)value - 0.5)) + 1.0f;
            float speedModifier = (float)Math.abs((Double)TiAcConfig.COMMON.ELECTRON_TUNER_ATTACK_SPEED_ADJUSTABLE_RANGE.get() * ((double)value - 0.5)) + 1.0f;
            if ((double)value - 0.5 < 0.0) {
                ToolStats.ATTACK_SPEED.multiply(modifierStatsBuilder, (double)speedModifier);
                ToolStats.ATTACK_DAMAGE.multiply(modifierStatsBuilder, (double)(1.0f / damageModifier));
            } else {
                ToolStats.ATTACK_SPEED.multiply(modifierStatsBuilder, (double)(1.0f / speedModifier));
                ToolStats.ATTACK_DAMAGE.multiply(modifierStatsBuilder, (double)damageModifier);
            }
        }
    }

    public LegacyDamageSource modifyDamageSource(IToolStackView tool, ModifierEntry entry, LivingEntity attacker, InteractionHand hand, Entity target, EquipmentSlot sourceSlot, boolean isFullyCharged, boolean isExtraAttack, boolean isCritical, LegacyDamageSource source) {
        if (((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue() && ElectronTunerItem.getMode(tool) == 0) {
            return source.setBypassArmor().setBypassInvulnerableTime();
        }
        return source;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Entity entity = context.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue()) {
                living.m_147215_(new MobEffectInstance((MobEffect)TinkerEffects.enderference.get(), 600, 0), (Entity)context.getAttacker());
            }
        }
    }

    public int getCapacity(ModifierEntry modifierEntry) {
        return 100000;
    }

    public void addTraits(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierTraitHook.TraitBuilder traitBuilder, boolean b) {
        if ((double)iToolContext.getPersistentData().getFloat(ElectronTunerItem.KEY_ATTACK_DAMAGE) > 0.75 && ((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue()) {
            traitBuilder.add(TinkerModifiers.severing.getId(), 3);
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifierEntry, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        if (ElectronTunerItem.getMode(tool) == 0 && ((Boolean)TiAcConfig.COMMON.ELECTRON_TUNER_SPECIAL_BONUS.get()).booleanValue()) {
            IToolUuidGetter.getUuid((IToolStackView)tool).ifPresent(uuid -> biConsumer.accept((Attribute)ForgeMod.ENTITY_REACH.get(), new AttributeModifier(uuid, ((Attribute)ForgeMod.ENTITY_REACH.get()).m_22087_(), 3.0, AttributeModifier.Operation.ADDITION)));
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        super.addTooltip(tool, modifierEntry, player, list, tooltipKey, tooltipFlag);
        ToolEnergyProduction production = ToolEnergyProduction.getOrCreate((ToolStack)tool);
        int value = production.lastGeneration;
        long remainedEnergyToGen = production.energyToProduce;
        long remainedEnergyToCost = production.energyToReduce;
        list.add((Component)Component.m_237113_((String)((value > 0 ? "+" : "") + MathUtil.getEnergyString((int)value) + "/t")).m_130940_(ChatFormatting.RED));
        list.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.energy_gen_remain").m_130946_(CommonUtil.getEnergyString(remainedEnergyToGen)).m_130940_(ChatFormatting.RED));
        list.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.energy_cost_remain").m_130946_(CommonUtil.getEnergyString(remainedEnergyToCost)).m_130940_(ChatFormatting.RED));
    }
}

