/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.common;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.content.block.StibniteOreBlock;
import com.c2h6s.tinkers_advanced.registery.TiAcBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class Unstable
extends EtSTBaseModifier
implements BreakSpeedModifierHook,
BlockBreakModifierHook {
    public static final ResourceLocation KEY_RANDOMIZE = TinkersAdvanced.getLocation("randomize");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BREAK_SPEED, ModifierHooks.BLOCK_BREAK);
    }

    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(KEY_RANDOMIZE);
        return super.onModifierRemoved(tool, modifier);
    }

    public static void randomize(IToolStackView tool) {
        tool.getPersistentData().putFloat(KEY_RANDOMIZE, RANDOM.nextFloat());
    }

    public static float randomizeAndGetNext(IToolStackView tool) {
        float f = RANDOM.nextFloat();
        tool.getPersistentData().putFloat(KEY_RANDOMIZE, f);
        return f;
    }

    public float getDamageMultiplier(IToolStackView tool, ModifierEntry entry) {
        float multiplier = Unstable.randomizeAndGetNext(tool);
        if ((double)multiplier < 0.75) {
            return -(1.0f - 1.0f / (1.0f + (multiplier *= 2.0f) * (float)entry.getLevel()));
        }
        multiplier -= 0.5f;
        return (multiplier *= 2.0f) * (float)entry.getLevel();
    }

    public void modifierProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        persistentData.putFloat(TinkersAdvanced.getLocation("unstable_damage"), this.getDamageMultiplier(tool, modifier));
    }

    public float onGetArrowDamage(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull Entity target, float baseDamage, float damage) {
        return damage + baseDamage * persistentData.getFloat(TinkersAdvanced.getLocation("unstable_damage"));
    }

    public float onGetMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        return damage + baseDamage * this.getDamageMultiplier(tool, modifier);
    }

    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        return amount + (int)(Unstable.randomizeAndGetNext(tool) * 10.0f) % modifier.getLevel();
    }

    public void onBreakSpeed(IToolStackView iToolStackView, ModifierEntry modifierEntry, PlayerEvent.BreakSpeed breakSpeed, Direction direction, boolean b, float v) {
        float multiplier;
        if (breakSpeed.getEntity() != null && breakSpeed.getPosition().isPresent()) {
            Level level = breakSpeed.getEntity().m_9236_();
            BlockState blockState = breakSpeed.getState();
            if (blockState.m_60713_((Block)TiAcBlocks.STIBNITE_ORE.get()) && ((Boolean)blockState.m_61143_((Property)StibniteOreBlock.STIBNITE_STATE)).booleanValue()) {
                blockState.m_61124_((Property)StibniteOreBlock.STIBNITE_STATE, (Comparable)Boolean.valueOf(false));
                level.m_46597_((BlockPos)breakSpeed.getPosition().get(), blockState);
            }
        }
        if ((double)(multiplier = iToolStackView.getPersistentData().getFloat(KEY_RANDOMIZE)) < 0.5) {
            breakSpeed.setNewSpeed(breakSpeed.getNewSpeed() / (1.0f + (multiplier *= 2.0f) * (float)modifierEntry.getLevel()));
        } else {
            multiplier -= 0.5f;
            breakSpeed.setNewSpeed(breakSpeed.getNewSpeed() * (1.0f + (multiplier *= 2.0f) * (float)modifierEntry.getLevel()));
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        Unstable.randomize(tool);
    }
}

