/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.compat.mekanism;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class RadiationBurning
extends EtSTBaseModifier {
    public static final IRadiationManager RADIATION_MANAGER = IRadiationManager.INSTANCE;

    public float onGetMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity living;
        LazyOptional optional;
        Entity entity = context.getTarget();
        if (entity instanceof LivingEntity && (optional = (living = (LivingEntity)entity).getCapability(Capabilities.RADIATION_ENTITY)).isPresent()) {
            IRadiationEntity cap = (IRadiationEntity)optional.orElse(null);
            float bonus = (float)Math.min((Double)TiAcConfig.COMMON.IRRADIUM_MAX_BONUS.get(), cap.getRadiation() * (Double)TiAcConfig.COMMON.IRRADIUM_BONUS_PER_Sv.get());
            if ((double)bonus > 0.001) {
                return damage + baseDamage * bonus;
            }
        }
        return damage;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Entity entity = context.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (context.isFullyCharged()) {
                RADIATION_MANAGER.radiate(living, (double)modifier.getLevel() * (Double)TiAcConfig.COMMON.IRRADIUM_RADIATION_INFLICT.get());
            }
        }
    }

    public float onGetArrowDamage(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull Entity target, float baseDamage, float damage) {
        LivingEntity living;
        LazyOptional optional;
        if (target instanceof LivingEntity && (optional = (living = (LivingEntity)target).getCapability(Capabilities.RADIATION_ENTITY)).isPresent()) {
            IRadiationEntity cap = (IRadiationEntity)optional.orElse(null);
            float bonus = (float)Math.min((Double)TiAcConfig.COMMON.IRRADIUM_MAX_BONUS.get(), cap.getRadiation() * (Double)TiAcConfig.COMMON.IRRADIUM_BONUS_PER_Sv.get());
            if ((double)bonus > 0.001) {
                return damage + baseDamage * bonus;
            }
        }
        return damage;
    }

    public void afterArrowHit(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull LivingEntity target, float damageDealt) {
        if (arrow.m_19880_().contains("is_critical")) {
            RADIATION_MANAGER.radiate(target, (double)entry.getLevel() * (Double)TiAcConfig.COMMON.IRRADIUM_RADIATION_INFLICT.get());
        }
    }
}

