/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.compat.thermal;

import cofh.core.client.CoreKeys;
import cofh.lib.util.helpers.StringHelper;
import com.c2h6s.etstlib.tool.modifiers.base.BasicFEModifier;
import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.network.TiAcPacketHandler;
import com.c2h6s.tinkers_advanced.network.packets.PCofhModSwitchC2S;
import com.c2h6s.tinkers_advanced.registery.TiAcModifiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class FluxInfused
extends BasicFEModifier {
    public static final ResourceLocation MODE_LOCATION = TinkersAdvanced.getLocation("cofh_mode");

    public FluxInfused() {
        MinecraftForge.EVENT_BUS.addListener(this::onKeyInput);
    }

    private void onKeyInput(InputEvent.Key event) {
        if (CoreKeys.MULTIMODE_DECREMENT.m_90859_()) {
            TiAcPacketHandler.sendToServer(new PCofhModSwitchC2S(true));
        } else if (CoreKeys.MULTIMODE_INCREMENT.m_90859_()) {
            TiAcPacketHandler.sendToServer(new PCofhModSwitchC2S(false));
        }
    }

    public static void switchMode(ServerPlayer player, boolean increment) {
        ToolStack tool = null;
        if (player.m_21205_().m_41720_() instanceof IModifiable && (tool = ToolStack.from((ItemStack)player.m_21205_())).getModifierLevel(TiAcModifiers.FLUX_INFUSED.getId()) <= 0) {
            tool = null;
        }
        if (player.m_21206_().m_41720_() instanceof IModifiable && tool == null && (tool = ToolStack.from((ItemStack)player.m_21206_())).getModifierLevel(TiAcModifiers.FLUX_INFUSED.getId()) <= 0) {
            tool = null;
        }
        if (tool == null) {
            return;
        }
        tool.getPersistentData().putInt(MODE_LOCATION, (tool.getPersistentData().getInt(MODE_LOCATION) + (increment ? 1 : -1)) % 3 + 3);
        for (ModifierEntry entry : tool.getModifierList()) {
            Modifier modifier = entry.getModifier();
            if (!(modifier instanceof FluxInfused)) continue;
            FluxInfused modifier2 = (FluxInfused)modifier;
            modifier2.onModeSwitch((IToolStackView)tool, player, entry);
        }
    }

    public static int getMode(IToolStackView tool) {
        return tool.getPersistentData().getInt(MODE_LOCATION) % 3;
    }

    public static int getMode(IModDataView toolData) {
        return toolData.getInt(MODE_LOCATION) % 3;
    }

    public int getCapacity(ModifierEntry modifier) {
        return (int)((double)modifier.getLevel() * 1000000.0);
    }

    public void onModeSwitch(IToolStackView tool, ServerPlayer player, ModifierEntry entry) {
    }

    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null) {
            tooltip.add((Component)Component.m_237110_((String)"info.cofh.mode_change", (Object[])new Object[]{Component.m_237117_((String)"key.cofh.mode_change_increment"), Component.m_237117_((String)"key.cofh.mode_change_decrement")}).m_130940_(ChatFormatting.YELLOW));
            if (CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_() == -1) {
                tooltip.add((Component)Component.m_237110_((String)"info.cofh.key_not_bound", (Object[])new Object[]{StringHelper.localize((String)"key.cofh.mode_change_increment")}).m_130940_(ChatFormatting.RED));
            }
            if (CoreKeys.MULTIMODE_DECREMENT.getKey().m_84873_() == -1) {
                tooltip.add((Component)Component.m_237110_((String)"info.cofh.key_not_bound", (Object[])new Object[]{StringHelper.localize((String)"key.cofh.mode_change_decrement")}).m_130940_(ChatFormatting.RED));
            }
        }
        super.addTooltip(iToolStackView, modifierEntry, player, tooltip, tooltipKey, tooltipFlag);
    }

    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_INFUSE_CONSUMPTION.get();
        if (ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * amount), (boolean)true) >= basicConsumption) {
            int reduce = ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * amount), (boolean)false) / basicConsumption;
            if (reduce >= amount) {
                return 0;
            }
            return amount - reduce;
        }
        return amount;
    }
}

