/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.compat.thermal;

import cofh.core.common.network.packet.client.OverlayMessagePacket;
import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.entity.ThermalSlashProjectile;
import com.c2h6s.tinkers_advanced.content.modifier.compat.thermal.FluxInfused;
import com.c2h6s.tinkers_advanced.data.TiAcMaterialIds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.build.EnchantmentModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class ThermalSlashModifier
extends FluxInfused
implements BreakSpeedModifierHook,
BlockBreakModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BREAK_SPEED, ModifierHooks.BLOCK_BREAK);
        hookBuilder.addModule((HookProvider)new EnchantmentModule.Constant(Enchantments.f_44987_, 1));
        hookBuilder.addModule((HookProvider)new EnchantmentModule.Constant(Enchantments.f_44982_, 1));
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        super.addToolStats(iToolContext, modifierEntry, modifierStatsBuilder);
        ToolStats.ATTACK_SPEED.percent(modifierStatsBuilder, ThermalSlashModifier.getMode(iToolContext.getPersistentData()) >= 2 ? 0.5 : 0.0);
    }

    public static void onOffHandSwing(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
    }

    @Override
    public void onModeSwitch(IToolStackView tool, ServerPlayer player, ModifierEntry entry) {
        OverlayMessagePacket.sendToClient((Component)Component.m_237115_((String)("msg.tinkers_advanced.flux_mode.thermal_slash." + ThermalSlashModifier.getMode(tool))), (ServerPlayer)player);
        MaterialNBT nbt = tool.getMaterials();
        ToolStack toolStack = (ToolStack)tool;
        block4: for (int i = 0; i < nbt.size(); ++i) {
            MaterialVariant variant = nbt.get(i);
            MaterialId materialId = variant.getId();
            if (!materialId.m_135827_().equals("tinkers_advanced") || !materialId.m_135815_().equals("activated_chromatic_steel")) continue;
            switch (ThermalSlashModifier.getMode(tool)) {
                case 1: {
                    toolStack.replaceMaterial(i, TiAcMaterialIds.Thermal.Variant.ACTIVATED_CHROMATIC_STEEL_ACTIVATED);
                    continue block4;
                }
                case 2: {
                    toolStack.replaceMaterial(i, TiAcMaterialIds.Thermal.Variant.ACTIVATED_CHROMATIC_STEEL_EMPOWERED);
                    continue block4;
                }
                default: {
                    toolStack.replaceMaterial(i, (MaterialVariantId)TiAcMaterialIds.Thermal.ACTIVATED_CHROMATIC_STEEL);
                }
            }
        }
    }

    public void onLeftClickBlock(IToolStackView tool, ModifierEntry entry, Player player, Level level, EquipmentSlot equipmentSlot, BlockState state, BlockPos pos) {
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
        float basicDamage = ((Double)TiAcConfig.COMMON.FLUX_SLASH_BASIC_SLASH_DAMAGE.get()).floatValue();
        float sharpnessBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_PER_SHARPNESS.get()).floatValue();
        float attackDamageBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_FROM_ATTACK_DAMAGE.get()).floatValue();
        if (ThermalSlashModifier.getMode(tool) == 2 && !level.f_46443_ && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)true) >= basicConsumption * 2 && (double)player.m_36403_(0.0f) > 0.8 && !tool.getItem().m_8096_(state)) {
            ThermalSlashProjectile projectile = new ThermalSlashProjectile(level);
            Vec3 to = player.m_20154_();
            projectile.m_146884_(player.m_146892_());
            projectile.m_6686_(to.f_82479_, to.f_82480_, to.f_82481_, 2.0f, 0.0f);
            projectile.m_5602_((Entity)player);
            projectile.modifierLevel = entry.getLevel();
            projectile.baseDamage = basicDamage;
            projectile.baseDamage += sharpnessBonus * (float)tool.getModifierLevel(ModifierIds.sharpness);
            projectile.baseDamage += attackDamageBonus * ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * attackDamageBonus;
            level.m_7967_((Entity)projectile);
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)false);
        }
    }

    public void onLeftClickEmpty(IToolStackView tool, ModifierEntry entry, Player player, Level level, EquipmentSlot equipmentSlot) {
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
        float basicDamage = ((Double)TiAcConfig.COMMON.FLUX_SLASH_BASIC_SLASH_DAMAGE.get()).floatValue();
        float sharpnessBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_PER_SHARPNESS.get()).floatValue();
        float attackDamageBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_FROM_ATTACK_DAMAGE.get()).floatValue();
        if (ThermalSlashModifier.getMode(tool) == 2 && !level.f_46443_ && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)true) >= basicConsumption * 2 && (double)player.m_36403_(0.0f) > 0.8) {
            ThermalSlashProjectile projectile = new ThermalSlashProjectile(level);
            Vec3 to = player.m_20154_();
            projectile.m_146884_(player.m_146892_());
            projectile.m_6686_(to.f_82479_, to.f_82480_, to.f_82481_, 2.0f, 0.0f);
            projectile.m_5602_((Entity)player);
            projectile.modifierLevel = entry.getLevel();
            projectile.baseDamage = basicDamage;
            projectile.baseDamage += sharpnessBonus * (float)tool.getModifierLevel(ModifierIds.sharpness);
            projectile.baseDamage += attackDamageBonus * ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * attackDamageBonus;
            level.m_7967_((Entity)projectile);
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)false);
        }
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity livingEntity;
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
        float basicDamage = ((Double)TiAcConfig.COMMON.FLUX_SLASH_BASIC_SLASH_DAMAGE.get()).floatValue();
        float sharpnessBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_PER_SHARPNESS.get()).floatValue();
        float attackDamageBonus = ((Double)TiAcConfig.COMMON.FLUX_SLASH_SLASH_DAMAGE_FROM_ATTACK_DAMAGE.get()).floatValue();
        if (ThermalSlashModifier.getMode(tool) == 2 && !context.getLevel().f_46443_ && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)true) >= basicConsumption * 2 && context.isFullyCharged() && (livingEntity = context.getAttacker()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ThermalSlashProjectile projectile = new ThermalSlashProjectile(context.getLevel());
            Vec3 to = player.m_20154_();
            projectile.m_146884_(player.m_146892_());
            projectile.m_6686_(to.f_82479_, to.f_82480_, to.f_82481_, 2.0f, 0.0f);
            projectile.m_5602_((Entity)player);
            projectile.baseDamage = basicDamage;
            projectile.baseDamage += sharpnessBonus * (float)tool.getModifierLevel(ModifierIds.sharpness);
            projectile.baseDamage += damage * attackDamageBonus;
            context.getLevel().m_7967_((Entity)projectile);
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)false);
        }
        return knockback;
    }

    public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
        this.afterMeleeHit(tool, modifier, context, damageAttempted);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
        float basicDamage = ((Double)TiAcConfig.COMMON.FLUX_SLASH_FLUX_DAMAGE.get()).floatValue();
        if (player != null && ThermalSlashModifier.getMode(tool) >= 1 && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)basicConsumption, (boolean)true) >= basicConsumption && context.isFullyCharged()) {
            context.getTarget().m_6469_((DamageSource)LegacyDamageSource.playerAttack((Player)player).setBypassMagic().setBypassInvulnerableTime().setBypassArmor().setMsgId("flux"), basicDamage);
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)basicConsumption, (boolean)false);
        }
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
            float digSpeed = ((Double)TiAcConfig.COMMON.FLUX_SLASH_DIG_SPEED_BONUS.get()).floatValue();
            switch (ThermalSlashModifier.getMode(tool)) {
                case 1: {
                    if (ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption / 2), (boolean)true) < basicConsumption / 4) break;
                    event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * digSpeed);
                    break;
                }
                case 2: {
                    if (ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)basicConsumption, (boolean)true) < basicConsumption / 2) break;
                    event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * digSpeed * 2.0f);
                    break;
                }
            }
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifierEntry, ToolHarvestContext toolHarvestContext) {
        if (toolHarvestContext.isEffective()) {
            int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_SLASH_CONSUMPTION.get();
            switch (ThermalSlashModifier.getMode(tool)) {
                case 1: {
                    ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption / 4), (boolean)false);
                    break;
                }
                case 2: {
                    ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption / 2), (boolean)false);
                    break;
                }
            }
        }
    }

    @Override
    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
    }
}

